% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supported_coins.R
\name{supported_coins}
\alias{supported_coins}
\title{CoinGecko coins}
\usage{
supported_coins(max_attempts = 3)
}
\arguments{
\item{max_attempts}{(double, positive): specifies the
maximum number of attempts to call the CoinGecko API (e.g., if
the first call fails for some reason). Additional attempts are
implemented with an exponential backoff. Defaults to 3.}
}
\value{
A tibble with three columns:
\itemize{
\item \code{coin_id} (character): coin IDs, ordered alphabetically;
\item \code{symbol} (character): coin symbols;
\item \code{name} (character): common names of the coins.
}
}
\description{
Retrieves a list of coins currently supported by the CoinGecko API
}
\details{
This function is based on the public
\href{https://www.coingecko.com/api/documentations/v3}{CoinGecko API},
which has a limit of 50 calls per minute. Please
keep this limit in mind when developing your applications.
}
\examples{
\donttest{
r <- supported_coins()
head(r, 10)
}
}
