% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supported_exchanges.R
\name{supported_exchanges}
\alias{supported_exchanges}
\title{CoinGecko exchanges}
\usage{
supported_exchanges(max_attempts = 3)
}
\arguments{
\item{max_attempts}{(double, positive): specifies the
maximum number of attempts to call the CoinGecko API (e.g., if
the first call fails for some reason). Additional attempts are
implemented with an exponential backoff. Defaults to 3.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{exchange_id} (character): exchange ID;
\item \code{name} (character): common name of the exchange;
\item \code{year_established} (integer): year when the exchange was established;
\item \code{country} (character): country where the exchange is registered and / or
has its headquarters;
\item \code{url} (character): web address of the exchange;
\item \code{trust_score} (integer): an indicator of how much an exchange can be
trusted (ranges from 1 to 10; see
\href{https://www.coingecko.com/en/methodology}{Methodology} on the CoinGecko
website);
\item \code{trading_volume_24h_btc} (double): trading volume in the last 24 hours,
expressed in Bitcoin.
}
}
\description{
Retrieves a list of exchanges supported by the CoinGecko API
}
\details{
This function is based on the public
\href{https://www.coingecko.com/api/documentations/v3}{CoinGecko API},
which has a limit of 50 calls per minute. Please
keep this limit in mind when developing your applications.
}
\examples{
\donttest{
r <- supported_exchanges()
print(r)
}
}
