/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.MCMCBond;
import gov.lanl.yadas.MCMCInput;
import gov.lanl.yadas.MCMCNode;
import gov.lanl.yadas.MCMCOutput;
import gov.lanl.yadas.MCMCUpdate;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class MCMCAnalysis {
    int progressreport = 1000;
    int skip = 1;
    boolean neverprint = false;
    String direc;
    public ArrayList filenames = new ArrayList();
    public ArrayList inputlist = new ArrayList();
    public ArrayList nodelist = new ArrayList();
    public ArrayList paramnames = new ArrayList();
    public ArrayList bondlist = new ArrayList();
    public ArrayList bondnames = new ArrayList();
    public ArrayList updatelist = new ArrayList();
    public ArrayList updatenames = new ArrayList();
    public ArrayList outputlist = new ArrayList();
    PrintWriter out;

    public MCMCAnalysis() {
        this("");
    }

    public MCMCAnalysis(String direc) {
        this.direc = direc;
        try {
            this.out = new PrintWriter(new FileWriter(direc + "logfile.txt"));
        }
        catch (IOException e) {
            System.out.print("Error: " + e);
            System.exit(1);
        }
    }

    public void addInput(MCMCInput innput) {
        this.inputlist.add(innput);
    }

    public void addInputs(MCMCInput[] innput) {
        for (int i = 0; i < innput.length; ++i) {
            this.inputlist.add(innput[i]);
        }
    }

    public void addNode(MCMCNode param) {
        this.nodelist.add(param);
    }

    public void addBond(MCMCBond bond) {
        this.bondlist.add(bond);
    }

    public void addUpdate(MCMCUpdate upd) {
        this.updatelist.add(upd);
    }

    public void addUpdates(MCMCUpdate[] upd) {
        for (int i = 0; i < upd.length; ++i) {
            this.updatelist.add(upd[i]);
        }
    }

    public void addOutput(MCMCOutput output) {
        this.outputlist.add(output);
    }

    public void addOutputs(MCMCOutput[] output) {
        for (int i = 0; i < output.length; ++i) {
            this.outputlist.add(output[i]);
        }
    }

    public void setDirec(String direc) {
        this.direc = direc;
    }

    public int numparams() {
        return this.numNodes();
    }

    public int numNodes() {
        return this.nodelist.size();
    }

    public MCMCNode getNode(int i) {
        return (MCMCNode)this.nodelist.get(i);
    }

    public int numbonds() {
        return this.bondlist.size();
    }

    public int numupdates() {
        return this.updatelist.size();
    }

    public void outclose() {
        this.out.close();
    }

    public void iterate(int B) {
        for (int b = 0; b < B; ++b) {
            int i;
            if ((double)b / (double)this.progressreport - (double)(b / this.progressreport) == 0.0 && !this.neverprint) {
                System.out.println(b);
            }
            for (i = 0; i < this.updatelist.size(); ++i) {
                ((MCMCUpdate)this.updatelist.get(i)).update();
            }
            for (i = 0; i < this.outputlist.size(); ++i) {
                ((MCMCOutput)this.outputlist.get(i)).output();
            }
        }
    }

    public void finish() {
        for (int iii = 0; iii < this.updatelist.size(); ++iii) {
            String acc = ((MCMCUpdate)this.updatelist.get(iii)).accepted();
            if (this.neverprint) continue;
            System.out.println("Update " + iii + ": " + acc);
        }
        for (int i = 0; i < this.nodelist.size(); ++i) {
            ((MCMCNode)this.nodelist.get(i)).finish();
        }
    }

    public void never_print() {
        this.neverprint = true;
    }
}

