/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import edu.uci.ics.jung.algorithms.transformation.FoldingTransformerFixed;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drugis.mtc.graph.GraphUtil;
import org.drugis.mtc.graph.SpanningTreeIterable;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.CompareUtil;
import org.drugis.mtc.parameterization.ConsistencyParameterization;
import org.drugis.mtc.parameterization.InconsistencyBaselineSearchProblem;
import org.drugis.mtc.parameterization.InconsistencyParameter;
import org.drugis.mtc.parameterization.NetworkModel;
import org.drugis.mtc.parameterization.NetworkParameter;
import org.drugis.mtc.parameterization.ParameterComparator;
import org.drugis.mtc.parameterization.Part;
import org.drugis.mtc.parameterization.Partition;
import org.drugis.mtc.parameterization.TreatmentComparator;
import org.drugis.mtc.search.DepthFirstSearch;

public class InconsistencyParameterization
extends ConsistencyParameterization {
    private final Map<Partition, Set<List<Treatment>>> d_cycleClasses;

    public static InconsistencyParameterization create(Network network) {
        Hypergraph<Treatment, Study> sGraph = NetworkModel.createStudyGraph(network);
        UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph = NetworkModel.createComparisonGraph(sGraph);
        Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> tree = InconsistencyParameterization.findSpanningTree(network.getStudies(), cGraph);
        Map<Partition, Set<List<Treatment>>> cycleClasses = InconsistencyParameterization.getCycleClasses(cGraph, tree);
        Map<Study, Treatment> baselines = InconsistencyParameterization.findStudyBaselines(network.getStudies(), cGraph, cycleClasses);
        InconsistencyParameterization pmtz = new InconsistencyParameterization(network, tree, cycleClasses, baselines);
        return pmtz;
    }

    public static Map<Partition, Set<List<Treatment>>> getCycleClasses(UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph, Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> tree) {
        HashSet nonTreeEdges = new HashSet(cGraph.getEdges());
        for (FoldingTransformerFixed.FoldedEdge edge : tree.getEdges()) {
            Pair vertices = new Pair(tree.getIncidentVertices(edge));
            nonTreeEdges.remove(cGraph.findEdge((Treatment)vertices.getFirst(), (Treatment)vertices.getSecond()));
        }
        HashMap<Partition, Set<List<Treatment>>> cycleClasses = new HashMap<Partition, Set<List<Treatment>>>();
        for (FoldingTransformerFixed.FoldedEdge edge : nonTreeEdges) {
            Pair vertices = new Pair(cGraph.getIncidentVertices(edge));
            List<Treatment> cycle = GraphUtil.findPath(tree, vertices.getFirst(), vertices.getSecond());
            cycle.add((Treatment)vertices.getFirst());
            cycle = InconsistencyParameterization.standardizeCycle(cycle);
            ArrayList<Part> parts = new ArrayList<Part>(cycle.size() - 1);
            for (int i = 1; i < cycle.size(); ++i) {
                parts.add(new Part(cycle.get(i - 1), cycle.get(i), ((FoldingTransformerFixed.FoldedEdge)cGraph.findEdge(cycle.get(i - 1), cycle.get(i))).getFolded()));
            }
            Partition partition = new Partition(parts).reduce();
            if (!cycleClasses.containsKey(partition)) {
                cycleClasses.put(partition, new HashSet());
            }
            ((Set)cycleClasses.get(partition)).add(cycle);
        }
        return cycleClasses;
    }

    public static int getInconsistencyDegree(Map<Partition, Set<List<Treatment>>> cycleClasses) {
        int icd = 0;
        for (Partition p : cycleClasses.keySet()) {
            if (!InconsistencyParameterization.isInconsistencyCycle(p)) continue;
            ++icd;
        }
        return icd;
    }

    public static boolean isInconsistencyCycle(Partition p) {
        return p.reduce().getParts().size() >= 3;
    }

    public static Map<Study, Treatment> findStudyBaselines(Collection<Study> studies, UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph) {
        return new DepthFirstSearch<Map<Study, Treatment>>().search(new InconsistencyBaselineSearchProblem(studies, cGraph));
    }

    public static Map<Study, Treatment> findStudyBaselines(Collection<Study> studies, UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph, Map<Partition, Set<List<Treatment>>> cycleClasses) {
        return new DepthFirstSearch<Map<Study, Treatment>>().search(new InconsistencyBaselineSearchProblem(studies, cGraph, cycleClasses));
    }

    public static Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> findSpanningTree(Collection<Study> studies, UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph) {
        boolean hasCompleteBaseline = InconsistencyParameterization.findStudyBaselines(studies, cGraph) != null;
        int nFunctional = cGraph.getEdgeCount() - cGraph.getVertexCount() + 1;
        int maxPossible = hasCompleteBaseline ? nFunctional : nFunctional - 1;
        int max = -1;
        Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> best = null;
        Treatment root = CompareUtil.findLeast(cGraph.getVertices(), TreatmentComparator.INSTANCE);
        SpanningTreeIterable<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> spanningTreeIterable = new SpanningTreeIterable<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>>(NetworkModel.toDirected(cGraph), root, TreatmentComparator.INSTANCE);
        for (Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> tree : spanningTreeIterable) {
            Map<Partition, Set<List<Treatment>>> cycleClasses = InconsistencyParameterization.getCycleClasses(cGraph, tree);
            int icd = InconsistencyParameterization.getInconsistencyDegree(cycleClasses);
            if (icd > max && icd <= maxPossible && (hasCompleteBaseline || InconsistencyParameterization.findStudyBaselines(studies, cGraph, cycleClasses) != null)) {
                max = icd;
                best = tree;
            }
            if (max != maxPossible) continue;
            return best;
        }
        return best;
    }

    public static List<Treatment> standardizeCycle(List<Treatment> cycle) {
        InconsistencyParameterization.assertCycle(cycle);
        List<Treatment> std = InconsistencyParameterization.rebaseCycle(cycle);
        if (TreatmentComparator.INSTANCE.compare(std.get(1), std.get(std.size() - 2)) > 0) {
            Collections.reverse(std);
        }
        return std;
    }

    private static List<Treatment> rebaseCycle(List<Treatment> cycle) {
        Treatment least = CompareUtil.findLeast(cycle, TreatmentComparator.INSTANCE);
        ArrayList<Treatment> std = new ArrayList<Treatment>();
        std.addAll(cycle.subList(cycle.indexOf(least), cycle.size()));
        std.addAll(cycle.subList(1, cycle.indexOf(least) + 1));
        return std;
    }

    private static void assertCycle(List<Treatment> cycle) {
        HashSet<Treatment> set = new HashSet<Treatment>(cycle);
        if (set.size() != cycle.size() - 1 || !cycle.get(0).equals(cycle.get(cycle.size() - 1))) {
            throw new IllegalStateException(cycle + " is not a cycle.");
        }
    }

    public InconsistencyParameterization(Network network, Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> tree, Map<Partition, Set<List<Treatment>>> cycleClasses, Map<Study, Treatment> baselines) {
        super(network, tree, baselines);
        this.d_cycleClasses = cycleClasses;
    }

    @Override
    public List<NetworkParameter> getParameters() {
        List<NetworkParameter> parameters = ConsistencyParameterization.getBasicParameters(this.d_tree);
        for (Map.Entry<Partition, Set<List<Treatment>>> entry : this.d_cycleClasses.entrySet()) {
            InconsistencyParameter param = this.getInconsistencyParameter(entry.getKey());
            if (param == null) continue;
            parameters.add(param);
        }
        Collections.sort(parameters, new ParameterComparator());
        return parameters;
    }

    @Override
    protected Map<NetworkParameter, Integer> parameterizeFunctional(Treatment ta, Treatment tb) {
        InconsistencyParameter param;
        Map<NetworkParameter, Integer> pmtz = super.parameterizeFunctional(ta, tb);
        List<Treatment> cycle = GraphUtil.findPath(this.d_tree, ta, tb);
        cycle.add(ta);
        Partition partition = this.findPartition(InconsistencyParameterization.standardizeCycle(cycle));
        if (partition != null && (param = this.getInconsistencyParameter(partition)) != null) {
            pmtz.put(param, -this.relativeDirection(InconsistencyParameterization.rebaseCycle(cycle), param.getCycle()));
        }
        return pmtz;
    }

    private int relativeDirection(List<Treatment> cycle, List<Treatment> ref) {
        Treatment plus = ref.get(1);
        Treatment minus = ref.get(ref.size() - 2);
        for (int i = 1; i < cycle.size() - 1; ++i) {
            if (cycle.get(i).equals(plus)) {
                return 1;
            }
            if (!cycle.get(i).equals(minus)) continue;
            return -1;
        }
        throw new IllegalStateException("Could not get relative directionality for " + cycle + " and " + ref);
    }

    private InconsistencyParameter getInconsistencyParameter(Partition p) {
        if (!InconsistencyParameterization.isInconsistencyCycle(p)) {
            return null;
        }
        return new InconsistencyParameter(InconsistencyParameterization.standardizeCycle(p.asCycle()));
    }

    private Partition findPartition(List<Treatment> cycle) {
        for (Map.Entry<Partition, Set<List<Treatment>>> entry : this.d_cycleClasses.entrySet()) {
            if (!entry.getValue().contains(cycle)) continue;
            return entry.getKey();
        }
        return null;
    }
}

