/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.drugis.mtc.Parameter;
import org.drugis.mtc.parameterization.BasicParameter;
import org.drugis.mtc.parameterization.InconsistencyParameter;
import org.drugis.mtc.parameterization.InconsistencyStandardDeviation;
import org.drugis.mtc.parameterization.RandomEffectsStandardDeviation;
import org.drugis.mtc.parameterization.SplitParameter;

public class ParameterComparator
implements Comparator<Parameter> {
    private static final List<Class<? extends Parameter>> classes = Arrays.asList(BasicParameter.class, SplitParameter.class, InconsistencyParameter.class, RandomEffectsStandardDeviation.class, InconsistencyStandardDeviation.class);

    @Override
    public int compare(Parameter o1, Parameter o2) {
        int par2Type;
        int par1Type = classes.indexOf(o1.getClass());
        if (par1Type < 0 | (par2Type = classes.indexOf(o2.getClass())) < 0) {
            throw new IllegalArgumentException("Attempt to compare unknown Parameter class : " + o1.getClass());
        }
        if (par1Type != par2Type) {
            return par1Type - par2Type;
        }
        if (o1 instanceof BasicParameter) {
            return ((BasicParameter)o1).compareTo((BasicParameter)o2);
        }
        if (o1 instanceof SplitParameter) {
            return ((SplitParameter)o1).compareTo((SplitParameter)o2);
        }
        if (o1 instanceof InconsistencyParameter) {
            return ((InconsistencyParameter)o1).compareTo((InconsistencyParameter)o2);
        }
        return 0;
    }
}

