/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.drugis.mtc.MCMCResults;

public class MCMCResultsWriter {
    private MCMCResults d_results;

    public MCMCResultsWriter(MCMCResults r) {
        this.d_results = r;
    }

    public void write(OutputStream o) throws IOException {
        this.write(new OutputStreamWriter(o));
    }

    public void write(Writer w) throws IOException {
        BufferedWriter out = new BufferedWriter(w);
        out.write("`trace` <-\n");
        out.write("structure(list(");
        String paramstr = "";
        for (int p = 0; p < this.d_results.getParameters().length; ++p) {
            String namestr = "\"" + this.d_results.getParameters()[p].getName() + "\"";
            paramstr = paramstr + namestr + ", ";
            out.write(namestr + " = structure(c(");
            for (int i = 0; i < this.d_results.getNumberOfChains(); ++i) {
                for (int j = 0; j < this.d_results.getNumberOfSamples(); ++j) {
                    Double d = this.d_results.getSample(p, i, j);
                    out.write(d.toString());
                    if (j == this.d_results.getNumberOfSamples() - 1 && i == this.d_results.getNumberOfChains() - 1) continue;
                    out.write(",");
                }
            }
            out.write("), .Dim = structure(c(1L," + this.d_results.getNumberOfSamples() + "L," + this.d_results.getNumberOfChains() + "L), ");
            out.write(".Names = c(\"\",\"iteration\",\"chain\")))");
            if (p >= this.d_results.getParameters().length - 1) continue;
            out.write(", \n");
        }
        paramstr = paramstr.substring(0, paramstr.length() - 2);
        out.write("), \n.Names = c(" + paramstr + "))\n");
        out.flush();
    }
}

