/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.Likelihood;
import gov.lanl.yadas.Tools;

public class Dirichlet
implements Likelihood {
    public double compute(double[][] args) {
        int i;
        double[] probs = args[0];
        double[] exponents = args[1];
        double out = 0.0;
        double sumnu = 0.0;
        for (i = 0; i < exponents.length; ++i) {
            sumnu += exponents[i];
        }
        out = Tools.loggamma(sumnu);
        for (i = 0; i < probs.length; ++i) {
            out -= Tools.loggamma(exponents[i]);
            if (!(exponents[i] > 0.0)) continue;
            out += (exponents[i] - 1.0) * Math.log(probs[i]);
        }
        return out;
    }

    public static double[] rep(double r, int n) {
        double[] out = new double[n];
        for (int i = 0; i < n; ++i) {
            out[i] = r;
        }
        return out;
    }

    public static void main(String[] args) {
        int n = 10;
        try {
            if (args.length > 0) {
                n = Integer.parseInt(args[0]);
            }
        }
        catch (NumberFormatException e) {
            System.out.println("first argument should be an integer");
        }
        Dirichlet di = new Dirichlet();
        System.out.println(di.compute(new double[][]{{0.4, 0.3, 0.2, 0.1}, {10.0, 0.1, 0.1, 0.1}}));
    }
}

