% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterData.R
\name{clusterData}
\alias{clusterData}
\title{Hierarchical clustering of normalized expression data}
\usage{
clusterData(norm.data, dist.method = "euclidean", agg.method = "complete")
}
\arguments{
\item{norm.data}{list of normalized expression data returned by 
\code{normalizeData}}

\item{dist.method}{The distance measure to be used. This must be one of 
"euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski".
See \code{\link[stats]{dist}} for more details.}

\item{agg.method}{The agglomeration method to be used. This must be one of 
"single", "complete", "average", "mcquitty", "ward.D", "ward.D2", 
"centroid" or "median". \code{\link[fastcluster]{hclust}} for more details.}
}
\value{
\code{rowdend1b} dendrogram from hierarchical clustering of genes on
  baseline samples normalized according to \code{norm.method} specified in 
  \code{norm.data}. NULL if \code{y1b} in \code{norm.data} is NULL.

\code{rowdend2b} dendrogram from hierarchical clustering of genes on
  baseline samples normalized to controls according to \code{norm.method} 
  specified in \code{norm.data}. NULL if \code{y2b} in \code{norm.data} is 
  NULL.

\code{rowdend1} dendrogram from hierarchical clustering of genes on
  all samples normalized according to \code{norm.method} specified in 
  \code{norm.data}. NULL if \code{y1} in \code{norm.data} is NULL.

\code{rowdend2} dendrogram from hierarchical clustering of genes on
  all samples normalized to controls according to \code{norm.method} 
  specified in \code{norm.data}. NULL if \code{y2} in \code{norm.data} is 
  NULL.

\code{rowdend3} dendrogram from hierarchical clustering of genes on
  all samples normalized to their baseline. NULL if \code{y3} in 
  \code{norm.data} is NULL.

\code{norm.method} string describing the normalization method used in
  \code{\link{normalizeData}}
}
\description{
Perform hierarchical clustering on normalized data
}
\details{
This function performs hierarchical clustering on the rows of the 
  normalized expression data contained in \code{norm.data}.
}
\examples{
# Example data
data(tb.expr)
data(tb.design)

# Use first 100 probes to demonstrate
dat <- tb.expr[1:100,]

# Create desInfo object
meta.data <- metaData(y = dat, design = tb.design, data.type = "microarray", 
                    columnname = "columnname", long = TRUE, sample.id = "sample_id",
                    subject.id = "monkey_id", time.var = "timepoint",
                    baseline.var = "timepoint", baseline.val = 0)

# Normalize data
data.norm <- normalizeData(meta = meta.data)

# Cluster data
dendros <- clusterData(norm.data = data.norm)
}
