% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/someCPairs.R
\name{someCPairs}
\alias{someCPairs}
\title{Function for kernel causality in 7-column matrix admitting control variables}
\usage{
someCPairs(mtx, ctrl, dig = 6, verbo = TRUE, rnam = FALSE, wt = c(1.2,
  1.1, 1.05, 1), sumwt = 4)
}
\arguments{
\item{mtx}{{The data matrix with many columns where the first column is fixed and then 
paired with all other columns, one by one.}}

\item{ctrl}{{data matrix for designated control variable(s) outside causal paths}}

\item{dig}{{Number of digits for reporting (default \code{dig}=6).}}

\item{verbo}{{Make \code{verbo= TRUE} for printing detailed steps.}}

\item{rnam}{{Make \code{rnam= TRUE} if cleverly created rownames are desired.}}

\item{wt}{{Allows user to choose a vector of four alternative weights for SD1 to SD4.}}

\item{sumwt}{{ Sum of weights can be changed here =4(default).}}
}
\value{
Prints three matrices detailing results for Cr1, Cr2 and Cr3.
It also returns a grand summary matrix called `outVote' which summarizes all three criteria.
In general, a positive sign for weighted sum reported in the column `sum' means
that the first variable listed as the input to this function is the `kernel cause.' 
This function is an extension of \code{some0Pairs} to allow for control variables. 
For example, crime `kernel causes' police officer deployment (not vice versa) is indicated by 
the positive sign of `sum' (=3.175) reported for that example included in this package.
}
\description{
Allowing input matrix of control variables, produce 7 column matrix
summarizing the results where the signs of
stochastic dominance order values (+1 or -1) are weighted by \code{wt=c(1.2,1.1, 1.05, 1)} to
compute an overall result for all orders of stochastic dominance by a weighted sum for
the crietria Cr1 and Cr2. The weighting is obviously not needed for the third criterion Cr3.
}
\details{
The reason for slightly declining weights on the signs from
SD1 to SD4 is simply that the local mean comparisons 
implicit in SD1 are known to be
more reliable than local variance implicit in SD2, local skewness implicit in
SD3 and local kurtosis implicit in SD4. The source of slightly declining sampling
unreliability of higher moments is the
higher power of the deviations from the mean needed in their computations.
The summary results for all
three criteria are reported in one matrix called \code{outVote}: 
  
typ=1 reports ('Y', 'X', 'Cause',
'SD1apdC', 'SD2apdC', 'SD3apdC', 'SD4apdC') nameing variables identifying 'cause'
and measures of stochastic dominance using absolute values of kernel
regression gradients (or amorphous partial derivatives, apd-s) being minimized by
the kernel regression algorithm while
comparing the kernel regresson of X on Y with that of Y on X.
The letter C in the titles reminds presence of control variable(s).

typ=2 reports ('Y', 'X', 'Cause', 'SD1resC', 'SD2resC', 'SD3resC', 'SD4resC')
and measures of stochastic dominance using absolute values of kernel
regression residuals comparing regresson of X on Y with that of Y on X.

typ=3 reports ('Y', 'X', 'Cause', 'r*x|yC', 'r*y|xC', 'r', 'p-val')
containing generalized correlation coefficients r*, 'r' refers to.
Pearson correlation coefficient p-val is the p-value for 
testing the significance of 'r'. 
The letter C in the titles reminds the presence of control variable(s).
}
\note{
The output matrix last column for `mtcars' example
has the sum of the scores by the three criteria
combined. If `sum' is positive, then variable X (mpg) is more likely to have been
engineerd to kernel cause the response variable Y, rather than vice versa.

The European Crime data has all three criteria correctly suggesting that
high crime rate kernel causes the deployment of a large number of police officers.
}
\examples{


\dontrun{
someCPairs(mtcars[,1:3],ctrl=mtcars[4:5]) # first variable is mpg and effect on mpg is of interest
}

set.seed(234)
z=runif(10,2,11)# z is independently created
x=sample(1:10)+z/10  #x is somewhat indep and affected by z
y=1+2*x+3*z+rnorm(10)
w=runif(10)
x2=x;x2[4]=NA;y2=y;y2[8]=NA;w2=w;w2[4]=NA
someCPairs(cbind(x2,y2), cbind(z,w2)) #yields x2 as correct cause


}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
\references{
'Generalized Correlation and Kernel Causality with
   Applications in Development Economics' in Communications in
   Statistics -Simulation and Computation, 2015,
   \url{http://dx.doi.org/10.1080/03610918.2015.1122048}
}
\seealso{
See Also \code{\link{somePairs}}, \code{\link{some0Pairs}}
}
\keyword{SD1,}
\keyword{SD2,}
\keyword{SD3,}
\keyword{SD4,}
\keyword{causal}
\keyword{correlations}
\keyword{criteria,}
\keyword{generalized}

