% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcorVecH.R
\name{parcorVecH}
\alias{parcorVecH}
\title{Vector of hybrid generalized partial correlation coefficients.}
\usage{
parcorVecH(mtx, ctrl = 0, dig = 4, verbo = FALSE, idep = 1)
}
\arguments{
\item{mtx}{{Input data matrix with p (> or = 3) columns, the first column
must have the dependent variable}}

\item{ctrl}{{Input vector or matrix of data for control variable(s), 
default is ctrl=0 when control variables are absent}}

\item{dig}{The number of digits for reporting (=4, default)}

\item{verbo}{Make this TRUE for detailed printing of computational steps}

\item{idep}{The column number of the dependent variable (=1, default)}
}
\value{
A p by 1 `out' vector containing hybrid partials  r*(i,j | k).
}
\description{
This is a hybrid version of parcorVec subtracting only the linear effects
(OLS residuals instead of kernel regression residuals), but using the
generalized correlation between the OLS residuals for the last stage
of the generalized partial correlation.
}
\details{
This function calls  \code{parcor_ijk} function, which
uses original data to compute
generalized partial correlations between \eqn{X_i}, the dependent variable,
and \eqn{X_j}, which is the current regressor of interest. Note that
j can be any one of the remaining
variables in the input matrix \code{mtx}. Partial correlations remove the effect of
variables \eqn{X_k} other than \eqn{X_i} and \eqn{X_j}. 
Calculation merges control variable(s) (if any) into \eqn{X_k}.
Let the remainder effect
from OLS regressions of \eqn{X_i} on \eqn{X_k} equal the  
residuals u(i,k). Analogously define u(j,k). It is a hybrid of OLS and generalized.  
Finally, partial correlation is generalized (kernel) correlation
between  u(i,k) and u(j,k).
}
\note{
Hybrid Generalized Partial Correlation Coefficients 
(HGPCC) allow comparison of
the relative contribution of each \eqn{X_j} to the explanation of \eqn{X_i},
because HGPCC has scale-free pure numbers.

We want to get all partial
 correlation coefficient pairs removing other column effects. Vinod (2018) 
 shows why one needs more than one criterion to decide the causal paths or exogeneity.
}
\examples{
set.seed(234)
z=runif(10,2,11)# z is independently created
x=sample(1:10)+z/10  #x is partly indep and partly affected by z
y=1+2*x+3*z+rnorm(10)# y depends on x and z not vice versa
mtx=cbind(x,y,z)
parcorVecH(mtx)
 
   
\dontrun{
set.seed(34);mtx=matrix(sample(1:600)[1:80],ncol=4)
colnames(mtx)=c('V1', 'v2', 'V3', 'V4')
parcorVecH(mtx,verbo=TRUE, idep=2)
}

}
\references{
Vinod, H. D. 'Generalized Correlations and Instantaneous
 Causality for Data Pairs Benchmark,' (March 8, 2015)
 \url{https://www.ssrn.com/abstract=2574891}

Vinod, H. D. 'Matrix Algebra Topics in Statistics and Economics
 Using R', Chapter 4 in Handbook of Statistics: Computational Statistics
 with R, Vol.32, co-editors: M. B. Rao and C.R. Rao. New York:
 North Holland, Elsevier Science Publishers, 2014, pp. 143-176.

Vinod, H. D. 'New Exogeneity Tests and Causal Paths,' 
(June 30, 2018). Available at SSRN: 
\url{https://www.ssrn.com/abstract=3206096}

Vinod, H. D. (2021) 'Generalized, Partial and Canonical Correlation
Coefficients' Computational Economics, 59(1), 1--28.
}
\seealso{
See Also \code{\link{parcor_ijk}}.

See Also \code{\link{parcorVec}}.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
\concept{partial correlations}
