% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silentPair2.R
\name{silentPair2}
\alias{silentPair2}
\title{kernel causality (version 2) scores with control variables}
\usage{
silentPair2(mtx, ctrl = 0, dig = 6)
}
\arguments{
\item{mtx}{{The data matrix with p columns. Denote x1 as the first column, 
which is fixed in all rows of the output and then it is
 paired with all other columns, say: x2, x3, .., xp, one by one for the 
 purpose of flipping with x1. p must be 2 or more}}

\item{ctrl}{{data matrix for designated control variable(s) outside causal paths,
default is ctrl=0, which means that there are no control variables used.}}

\item{dig}{{Number of digits for reporting (default \code{dig}=6).}}
}
\value{
A matrix with p columns in \code{mtx} argument to this function, x1 can be 
paired with a total of p-1 columns (x2, x3, .., xp). Note
we never flip any of the control variables with x1.  This function
produces i=1,2,..,p-1 numbers representing the summary sign, or `sum' from 
the signs sg1 to sg3 associated with the three criteria:
Cr1, Cr2, and Cr3.  Note that sg1 and sg2 themselves are weighted signs using 
a weighted sum of signs from four orders of stochastic dominance.
In general, a positive sign in the i-th location of the `sum' output of this function
means that x1 is the kernel cause while the variable in (i+1)-th column of \code{mtx} is the
`effect' or `response' or `endogenous.' The magnitude represents the strength (unanimity)
of the evidence for a particular sign. Conversely, a negative sign
 in the i-th location of the `sum' output of this function means 
that the first variable listed as the input to this function is the `effect,'
while the variable in (i+1)-th column of \code{mtx} is the exogenous kernel cause.
}
\description{
This function uses flipped kernel regressions to decide causal directions. 
This version 2 avoids Anderson's trapezoidal approximation used in
`silenPairs.' It calls functions: decileVote, momentVote, exactSdMtx, 
and summaryRank
after stochastic dominance is computed. It computes 
an average of ranks used. The column with the ``choice'' rank
 value helps in choosing the flip having the lowest 
 Hausman-Wu (residual times RHS regressor)
 and secondly the lowest absolute 
 residual. The chosen  flipped regression defines
 the ``cause" based on the variable on its right-hand side. In portfolio
 selection, choice rank 1 has the highest return. Here we want low residuals and
 low Hausman-Wu value, hence we choose choice=2 as the desirable flip.
 
 
The function develops a unanimity index regarding the particular
flip (y on xi) or (xi on y) is best. A summary of all relevant signs determines the
causal direction and unanimity index among three criteria.
The `2' in the name of the function suggests a second implementation
where exact stochastic dominance, decileVote, and momentVote algorithms are used.
}
\note{
The European Crime data has all three criteria correctly suggesting that a
high crime rate kernel causes the deployment of a large number of police officers.
The command \code{attach(EuroCrime); silentPairs(cbind(crim,off))}
returns only one number: 3.175, implying the highest unanimity strength index,
with the positive sign suggesting `crim' in the first column kernel causes
`off' in the second column of the argument \code{mtx} to this function.
}
\examples{


\dontrun{
options(np.messages=FALSE)
colnames(mtcars[2:ncol(mtcars)])
silentPair2(mtcars[,1:3],ctrl=mtcars[,4:5]) # mpg paired with others
}

options(np.messages=FALSE)
set.seed(234)
z=runif(10,2,11)# z is independently created
x=sample(1:10)+z/10 #x is somewhat indep and affected by z
y=1+2*x+3*z+rnorm(10)
w=runif(10)
x2=x;x2[4]=NA;y2=y;y2[8]=NA;w2=w;w2[4]=NA
silentPair2(mtx=cbind(x2,y2), ctrl=cbind(z,w2))


}
\references{
H. D. Vinod  'Generalized Correlation and Kernel Causality with
   Applications in Development Economics' in Communications in
   Statistics -Simulation and Computation, 2015,
   \doi{10.1080/03610918.2015.1122048}

Vinod, H. D. Causal Paths and Exogeneity Tests 
in {Generalcorr} Package for Air Pollution and Monetary Policy 
(June 6, 2017). Available at SSRN: 
\url{https://www.ssrn.com/abstract=2982128}
}
\seealso{
See  \code{\link{summaryRank}}, \code{\link{decileVote}}

See  \code{\link{momentVote}}, \code{\link{exactSdMtx}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
\concept{Hausman-Wu exogeneity criteria}
\concept{generalized correlations}
\concept{stochastic dominance}
