% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ind.R
\name{read_ind}
\alias{read_ind}
\title{Read eigenstrat *.ind files}
\usage{
read_ind(file, verbose = TRUE)
}
\arguments{
\item{file}{Input file (whatever is accepted by readr::read_table2).
If file as given does not exist and is missing the expected *.ind extension, the function adds the .ind extension and uses that path if that file exists.
Additionally, the .gz extension is added automatically if the file (after *.ind extension is added as needed) is still not found and did not already contained the .gz extension and adding it points to an existing file.}

\item{verbose}{If TRUE (default) function reports the path of the file being loaded (after autocompleting the extensions).}
}
\value{
A tibble with columns: id, sex, label.
}
\description{
This function reads a standard eigenstrat *.ind file into a tibble.
It uses readr::read_table2 to do it efficiently.
}
\examples{
# read an existing eigenstrat *.ind file
file <- system.file("extdata", 'sample.ind', package = "genio", mustWork = TRUE)
ind <- read_ind(file)
ind

# can specify without extension
file <- sub('\\\\.ind$', '', file) # remove extension from this path on purpose
file # verify .ind is missing
ind <- read_ind(file) # load it anyway!
ind

}
\seealso{
Eigenstrat IND format reference:
\url{https://github.com/DReichLab/EIG/tree/master/CONVERTF}
}
