% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_matrix.R
\name{write_matrix}
\alias{write_matrix}
\title{Write a matrix to a file without row or column names}
\usage{
write_matrix(file, x, ext = "txt", verbose = TRUE, append = FALSE)
}
\arguments{
\item{file}{Output file (whatever is accepted by \code{\link[readr:write_delim]{readr::write_tsv()}}).
If file is missing the expected extension (see below), the function adds it.}

\item{x}{The matrix to write.
Unlike \code{\link[=read_matrix]{read_matrix()}}, this is not in fact required to be a matrix or be strictly numeric; anything that coerces to tibble or data.frame is acceptable.}

\item{ext}{The desired file extension.
If \code{NA}, no extension is added.
Works if \code{file} already contains desired extension.}

\item{verbose}{If \code{TRUE} (default), function reports the path of the file being written (after autocompleting the extension).}

\item{append}{If \code{TRUE}, appends rows onto the file. (Default is \code{FALSE}).}
}
\value{
The output \code{x}, coerced into data.frame, invisibly (what \code{\link[readr:write_delim]{readr::write_tsv()}} returns).
}
\description{
The inverse function of \code{\link[=read_matrix]{read_matrix()}}, this writes what is intended to be a numeric matrix to a tab-delimited file without row or column names present.
It uses \code{\link[readr:write_delim]{readr::write_tsv()}} to do it efficiently.
Intended for outputs such as those of admixture inference approaches.
}
\examples{
# to write an existing matrix `x` into file "data.txt", run like this:
# write_matrix( "data", x )
# this also works
# write_matrix( "data.txt", x )

# The following example is more detailed but also more awkward
# because (only for these examples) the package must create the file in a *temporary* location

# create a dummy matrix with the right columns
x <- rbind( 1:3, (0:2)/10, -1:1 )
# a dummy file
file_out <- tempfile('delete-me-example', fileext = '.txt') # will also work without extension
# write the matrix without header
write_matrix( file_out, x )
# delete output when done
file.remove( file_out )

}
\seealso{
\code{\link[=read_matrix]{read_matrix()}}, the inverse function.
}
