% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genscore.R
\name{get_h_hp_vector}
\alias{get_h_hp_vector}
\title{Generator of h and hp (derivative of h) functions.}
\usage{
get_h_hp_vector(mode, para = NULL, para2 = NULL)
}
\arguments{
\item{mode}{A string, see details.}

\item{para}{May be optional. A number, the first parameter. Default to \code{NULL}.}

\item{para2}{May be optional. A number, the second parameter. Default to \code{NULL}.}
}
\value{
A function that returns a matrix with \code{hx=h(x)} (element-wise) and \code{hpx=hp(x)} (element-wise derivative of \eqn{h}) \code{cbind}ed when applied to a vector or a matrix \code{x}, where if \code{x} is a vector, the returned value will have two columns and number of rows equal to \code{length(x)}, otherwise it will have the same number of rows as \code{x} and number of columns doubled.
}
\description{
Generator of \code{h} and \code{hp} (derivative of \eqn{h}) functions.
}
\details{
Helper function of \code{get_h_hp()}. Please refer to \code{get_hs_hp()}.
}
\examples{
get_h_hp_vector("mcp", 2, 4)
get_h_hp_vector("min_log_pow", 1, log(1+3))
get_h_hp_vector("min_pow", 1, 3)
get_h_hp_vector("min_softplus")
}
