% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genscore.R
\name{parse_ab}
\alias{parse_ab}
\title{Parses an ab setting into rational numbers a and b.}
\usage{
parse_ab(s)
}
\arguments{
\item{s}{A string starting with "ab_", followed by rational numbers a and b separated by "_". a and b must be integers or rational numbers of the form "int/int". See examples.}
}
\value{
A list of the following elements:
   \item{a_numer}{The numerator of \code{a}.}
   \item{a_denom}{The denominator of \code{a}.}
   \item{b_numer}{The numerator of \code{b}.}
   \item{b_denom}{The denominator of \code{b}.}
}
\description{
Parses an ab setting into rational numbers a and b.
}
\examples{
parse_ab("ab_1_1") # gaussian: a = 1, b = 1
parse_ab("ab_2_5/4") # a = 2, b = 5/4
parse_ab("ab_5/4_3/2") # a = 5/4, b = 3/2
parse_ab("ab_3/2_0/0") # a = 3/2, b = 0/0 (log)
parse_ab("ab_1/2_0/0") # exp: a = 1/2, b = 0/0 (log)
}
