% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain.R
\name{parse_ineq}
\alias{parse_ineq}
\title{Parses an ineq expression into a list of elements that represents the ineq.}
\usage{
parse_ineq(s, p)
}
\arguments{
\item{s}{A string, an ineq expression. Please refer \code{make_domain()}.}

\item{p}{An integer, the dimension.}
}
\value{
A list containing the following elements:
 \item{uniform}{A logical, indicates whether the ineq is a uniform expression that applies to each component independently (e.g. \code{x^2>1}, \code{exp(3*|x|)<3.4}).}
 \item{const}{A number, the constant side of the ineq that the variable side should compare to (e.g. \code{1.3} in \code{x1^2+2*x2^3>1.3}).}
 \item{larger}{A logical, indicates whether the variable side of the expression should be larger or smaller than \code{const}.}
 \item{power_numers}{A single number or a vector of length \code{p}. The numerators of the powers in the ineq for each component (e.g. \code{c(2,3,5,0,-2)} for \cr
      \code{x1^2+2*x2^(3/2)+3*x3^(5/3)+4*log(x4)+5*exp(-2*x)>1}).}
 \item{power_denoms}{A single number or a vector of length \code{p}. The denominators of the powers in the ineq for each component (e.g. \code{c(1,2,3,0,0)} for \cr
      \code{x1^2+2*x2^(3/2)+3*x3^(5/3)+4*log(x4)+5*exp(-2*x)>1}).}
 \item{coeffs}{A vector of length \code{p} that represents the coefficients in the ineq associated with each component. Returned only if \code{uniform == FALSE}.}
}
\description{
Parses an ineq expression into a list of elements that represents the ineq.
}
\details{
Please refer \code{make_domain()} for the syntax of the expression.
}
\examples{
p <- 30
parse_ineq("sum(x^2)>10", p)
parse_ineq("sum(x^(1/3))>10", p)
parse_ineq("x1>1", p)
parse_ineq("x2<1", p)
parse_ineq("exp(x)>1.3", p)
parse_ineq("sum(log(x)) < 2", p)
parse_ineq("x1^(2/3)-1.3x2^(-3)<1", p)
parse_ineq("exp(x1)+2.3*x2^2 > 2", p)
parse_ineq(paste(paste(sapply(1:p,
                           function(j){paste(j, "x", j, sep="")}), collapse="+"), "<1"), p)

parse_ineq("0.5*x1^(-2/3)-x3^3 + 2log(x2)- 1.3e4exp(-25*x6)+x8-.3x5^(-3/-4) >= 2", 8)
parse_ineq("0.5*x1^(-2/3)-x2^(4/-6)+2e3x3^(-6/9) < 3.5e5", 3)
parse_ineq("x^(-2/3)<=3e3", 5)
parse_ineq("sum(x^(-2/3))<=3e3", 5)
parse_ineq("x<=3e3", 5)
parse_ineq("sum(x)<=3e3", 5)
parse_ineq("exp(-23x)<=3e3", 5)
parse_ineq("sum(exp(-23x))<=3e3", 5)
}
