% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dataset_doc.R
\docType{data}
\name{eyjar}
\alias{eyjar}
\title{Icelandic islands}
\format{A data frame with 3401 (including NAs) observations on the following
2 variables.

\describe{ \item{lat}{a numeric vector}, \item{lon}{a
numeric vector}: latitude and longitude of coastlines of Icelandic islands
given as decimal degrees.  }}
\source{
GSHHS - A Global Self-consistent, Hierarchical, High-resolution
Shoreline Database, version 2.2.
}
\description{
Islands around Iceland with area greater than 0.25 square km
}
\details{
Islands around Iceland extracted from \code{gshhs_f.b} with area greater
than 1/4 of a square kilometer. Script available as
\url{http://www.hafro.is/~sigurdur/gshhsIslands/newEyjar.R}.
}
\examples{
data(eyjar)
# islands in the Breidafjordur region
geoplot(xlim = list(lat = c(64.85, 65.65), lon = c(-24.6, -21.7)),
  country = bisland, grid = FALSE)
geolines(eyjar, col = "magenta")
## maybe str(eyjar) ; plot(eyjar) ...
}
\keyword{datasets}

