% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eph.R
\name{get_eph}
\alias{get_eph}
\title{Carga poligonos de los Aglomerados Urbanos correspondientes a la Encuesta Permanente de Hogares (INDEC)}
\usage{
get_eph(
  geo = "ARGENTINA",
  simplified = TRUE,
  centroid = FALSE,
  level = "envolventes"
)
}
\arguments{
\item{geo}{un character con el nombre del distrito que se quiere descargar.
Se puede chequear el id con \code{\link{show_arg_codes}}.}

\item{simplified}{por defecto es TRUE y determina la descarga de una versión simplificada de las geometrias.
Con FALSE descarga la versión original de INDEC}

\item{centroid}{por defecto devuelve poligonos como geometry pero pueden descargarse puntos (centroides correspondientes al level especificado)}

\item{level}{por defecto devuelve a nivel \code{envolvente} pero puede descargarse a nivel \code{radios} y \code{entidades}}
}
\value{
tibble con capa geografica correspondiente a alguna versión de geometrías utilizadas en la Encuesta Permanente de Hogares (EPH)
}
\description{
Carga poligonos de los Aglomerados Urbanos correspondientes a la Encuesta Permanente de Hogares (INDEC)
}
\examples{
get_eph(geo = "TUCUMAN")

}
