% Generated by roxygen2 (4.0.1.99): do not edit by hand
\docType{package}
\name{geoBayes}
\alias{geoBayes}
\alias{geoBayes-package}
\title{The \code{geoBayes} package}
\description{
Analysis of geostatistical data using Bayes and Empirical Bayes
methods.
}
\details{
This package provides functions to fit geostatistical data. The
data can be continuous, binary or count data and the models
implemented are flexible. Conjugate priors are assumed on some
parameters while inference on the other parameters can be done
through a full Bayesian analysis of by empirical Bayes methods.

Some demonstration examples are provided. Type \code{demo(package
= "geoBayes")} to examine them.
}
\examples{
\dontrun{
demo(package = "geoBayes")
demo(rhizoctonia3, package = "geoBayes")
}
}
\author{
Evangelos Evangelou <e.evangelou@maths.bath.ac.uk> and
Vivekananda Roy <vroy@iastate.edu>
}
\references{
Roy, V., Evangelou, E. and Zhu, Z. (2014). Empirical
Bayes methods for the transformed Gaussian random fields model
with additive measurement errors. In Upadhyay, S. K., Singh, U.,
Dey, D. K., and Loganathan, A., editors, \emph{Current Trends in
Bayesian Methodology with Applications}, Boca Raton, FL, USA, CRC
Press.

Roy, V., Evangelou, E., and Zhu, Z. (2014). Efficient estimation
and prediction for the Bayesian spatial generalized linear mixed
model with flexible link functions. Technical report, Iowa State
University.
}
\seealso{
\code{geoR}, \code{geoRglm}
}
\keyword{package}

