% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcsp2.R
\name{mcstrga}
\alias{mcstrga}
\title{MCMC samples from the transformed Gaussian model}
\usage{
mcstrga(
  formula,
  data,
  weights,
  subset,
  offset,
  atsample,
  corrfcn = "matern",
  linkp,
  phi,
  omg,
  kappa,
  Nout,
  Nthin = 1,
  Nbi = 0,
  betm0,
  betQ0,
  ssqdf,
  ssqsc,
  tsqdf,
  tsqsc,
  corrpriors,
  corrtuning,
  longlat = FALSE,
  test = FALSE
)
}
\arguments{
\item{formula}{A representation of the model in the form
\code{response ~ terms}. The response must be set to \code{NA}'s
at the prediction locations (see the example in
\code{\link{mcsglmm}} for how to do this using
\code{\link{stackdata}}). At the observed locations the response
is assumed to be a total of replicated measurements. The number of
replications is inputted using the argument \code{weights}.}

\item{data}{An optional data frame containing the variables in the
model.}

\item{weights}{An optional vector of weights. Number of replicated
samples.}

\item{subset}{An optional vector specifying a subset of
observations to be used in the fitting process.}

\item{offset}{See \code{\link[stats]{lm}}.}

\item{atsample}{A formula in the form \code{~ x1 + x2 + ... + xd}
with the coordinates of the sampled locations.}

\item{corrfcn}{Spatial correlation function. See
\code{\link{geoBayes_correlation}} for details.}

\item{linkp}{Parameter of the link function. A scalar value.}

\item{phi}{Optional starting value for the MCMC for the
spatial range parameter \code{phi}. Defaults to the mean of its
prior. If \code{corrtuning[["phi"]]} is 0, then this argument is required and
it corresponds to the fixed value of \code{phi}. This can be a
vector of the same length as Nout.}

\item{omg}{Optional starting value for the MCMC for the
relative nugget parameter \code{omg}. Defaults to the mean of
its prior. If \code{corrtuning[["omg"]]} is 0, then this argument is required
and it corresponds to the fixed value of \code{omg}. This can be
a vector of the same length as Nout.}

\item{kappa}{Optional starting value for the MCMC for the
spatial correlation parameter \code{kappa} (Matern smoothness or
exponential power). Defaults to the mean of
its prior. If \code{corrtuning[["kappa"]]} is 0 and it is needed for
the chosen correlation function, then this argument is required
and it corresponds to the fixed value of \code{kappa}. This can be
a vector of the same length as Nout.}

\item{Nout}{Number of MCMC samples to return. This can be a vector
for running independent chains.}

\item{Nthin}{The thinning of the MCMC algorithm.}

\item{Nbi}{The burn-in of the MCMC algorithm.}

\item{betm0}{Prior mean for beta (a vector or scalar).}

\item{betQ0}{Prior standardised precision (inverse variance)
matrix. Can be a scalar, vector or matrix. The first two imply a
diagonal with those elements. Set this to 0 to indicate a flat
improper prior.}

\item{ssqdf}{Degrees of freedom for the scaled inverse chi-square
prior for the partial sill parameter.}

\item{ssqsc}{Scale for the scaled inverse chi-square prior for the
partial sill parameter.}

\item{tsqdf}{Degrees of freedom for the scaled inverse chi-square
prior for the measurement error parameter.}

\item{tsqsc}{Scale for the scaled inverse chi-square prior for the
measurement error parameter.}

\item{corrpriors}{A list with the components \code{phi},
\code{omg} and \code{kappa} as needed. These correspond to the
prior distribution parameters. For \code{phi} and \code{omg} it
must be a vector of length 4. The generalized inverse gamma
prior is assumed and the input corresponds to the parameters
scale, shape, exponent, location in that order (see Details).
For \code{kappa} it must be a vector of length 2. A uniform
prior is assumed and the input corresponds to the lower and
upper bounds in that order.}

\item{corrtuning}{A vector or list with the components \code{phi},
\code{omg} and \code{kappa} as needed. These correspond to the
random walk parameter for the Metropolis-Hastings step. Smaller values
increase the acceptance ratio. Set this to 0 for fixed
parameter value.}

\item{longlat}{How to compute the distance between locations. If
\code{FALSE}, Euclidean distance, if \code{TRUE} Great Circle
distance. See \code{\link[sp]{spDists}}.}

\item{test}{Whether this is a trial run to monitor the acceptance
ratio of the random walk for \code{phi} and \code{omg}. If set to
\code{TRUE}, the acceptance ratio will be printed on the screen
every 100 iterations of the MCMC. Tune the \code{phisc} and
\code{omgsc} parameters in order to achive 20 to 30\% acceptance.
Set this to a positive number to change the default 100. No
thinning or burn-in are done when testing.}
}
\value{
A list containing the objects \code{MODEL}, \code{DATA},
  \code{FIXED}, \code{MCMC} and \code{call}. The MCMC samples are
  stored in the object \code{MCMC} as follows:
\itemize{
 \item \code{z} A matrix containing the MCMC samples for the
spatial random field. Each column is one sample.
 \item \code{mu} A matrix containing the MCMC samples for the
mean response (a transformation of z). Each column is one sample.
 \item \code{beta} A matrix containing the MCMC samples for the
regressor coefficients. Each column is one sample.
 \item \code{ssq} A vector with the MCMC samples for the partial
 \item \code{tsq} A vector with the MCMC samples for the
measurement error variance.
 \item \code{phi} A vector with the MCMC samples for the spatial
range parameter, if sampled.
 \item \code{omg} A vector with the MCMC samples for the relative
nugget parameter, if sampled.
 \item \code{logLik} A vector containing the value of the
log-likelihood evaluated at each sample.
 \item \code{acc_ratio} The acceptance ratio for the joint update
of the parameters \code{phi} and \code{omg}, if sampled.
 \item \code{sys_time} The total computing time for the MCMC sampling.
 \item \code{Nout}, \code{Nbi},  \code{Nthin} As in input. Used
internally in other functions.
}
The other objects contain input variables. The object \code{call}
  contains the function call.
}
\description{
Draw MCMC samples from the transformed Gaussian model with known
link function
}
\details{
Simulates from the posterior distribution of this model.
}
\examples{
\dontrun{
### Load the data
data(rhizoctonia)
rhiz <- na.omit(rhizoctonia)
rhiz$IR <- rhiz$Infected/rhiz$Total # Incidence rate of the
                              # rhizoctonia disease

### Define the model
corrf <- "spherical"
ssqdf <- 1
ssqsc <- 1
tsqdf <- 1
tsqsc <- 1
betm0 <- 0
betQ0 <- diag(.01, 2, 2)
phiprior <- c(200, 1, 1000, 100) # U(100, 300)
phisc <- 1
omgprior <- c(3, 1, 1000, 0) # U(0, 3)
omgsc <- 1
linkp <- 1

## MCMC parameters
Nout <- 100
Nbi <- 0
Nthin <- 1

samplt <- mcstrga(Yield ~ IR, data = rhiz,
                  atsample = ~ Xcoord + Ycoord, corrf = corrf,
                  Nout = Nout, Nthin = Nthin,
                  Nbi = Nbi, betm0 = betm0, betQ0 = betQ0,
                  ssqdf = ssqdf, ssqsc = ssqsc,
                  tsqdf = tsqdf, tsqsc = tsqsc,
                  corrprior = list(phi = phiprior, omg = omgprior),
                  linkp = linkp,
                  corrtuning = list(phi = phisc, omg = omgsc, kappa = 0),
                  test=10)

sample <- update(samplt, test = FALSE)
}
}
