% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\name{spc.plot.depth.plotly}
\alias{spc.plot.depth.plotly}
\alias{spc.plot.depth.plotly,Spectra-method}
\title{Display a Spectra object}
\usage{
spc.plot.depth.plotly(
  sp,
  column,
  plot.max = 10,
  showlegend = FALSE,
  hoverinfo = "name",
  title = sp@LongName
)

\S4method{spc.plot.depth.plotly}{Spectra}(
  sp,
  column,
  plot.max = 10,
  showlegend = FALSE,
  hoverinfo = "name",
  title = sp@LongName
)
}
\arguments{
\item{sp}{A \code{Spectra} object}

\item{column}{Number or name , default  value is 10 if a number or name has not been entered}

\item{plot.max}{numeric value for a maximum number of data in plot}

\item{showlegend}{logical, to display legend or not, default is FALSE}

\item{hoverinfo}{a chracter, info about  \code{Spectra} object to be used  in hover box}

\item{title}{a chracter string, title for plot}
}
\description{
Plot a \code{Spectra} object with respect to depth
}
\examples{
sp = spc.example_spectra()
BL = spc.makeSpcList(sp,"CAST")
p1<-spc.plot.depth.plotly(BL[[5]])
#p1<-layout(p1,title=paste("CAST =", BL[[5]]$CAST[1]))
p2<-spc.plot.depth.plotly(BL[[4]])
#p2<-plotly::layout(p2,title=paste("CAST =", BL[[4]]$CAST[1]))
p <- plotly::subplot(p1, p2,  margin = 0.05, shareY=TRUE,shareX=TRUE,titleX=TRUE,titleY=TRUE)
p <- plotly::layout(p, showlegend = TRUE, 
annotations = list(
list(x = 0.2 , y = 1.05, text = BL[[5]]$CAST[1], showarrow = FALSE, xref='paper', yref='paper'),
list(x = 0.8 , y = 1.05, text = BL[[4]]$CAST[1], showarrow = FALSE, xref='paper', yref='paper')))
p
}
