% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_neighborhood.R
\name{read_neighborhood}
\alias{read_neighborhood}
\title{Download neighborhood limits of Brazilian municipalities as an sf object}
\usage{
read_neighborhood(year = 2010, simplified = TRUE, showProgress = TRUE)
}
\arguments{
\item{year}{Year of the data (defaults to 2010)}

\item{simplified}{Logic TRUE or FALSE, indicating whether the function returns the 'original' dataset with high resolution or a dataset with 'simplified' borders (Defaults to TRUE)}

\item{showProgress}{Logical. Defaults to (TRUE) display progress bar}
}
\description{
This data set includes the neighborhood limits of 720 Brazilian municipalities.
It is based on aggregations of the census tracts from the Brazilian
census. Only 2010 data is currently available.
}
\examples{
\dontrun{

library(geobr)

# Read neighborhoods of Brazilian municipalities
  n <- read_neighborhood(year=2010)
}

}
\seealso{
Other general area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_census_tract}()},
\code{\link{read_conservation_units}()},
\code{\link{read_country}()},
\code{\link{read_immediate_region}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipality}()},
\code{\link{read_region}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_statistical_grid}()},
\code{\link{read_weighting_area}()}
}
\concept{general area functions}
