% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_urban_area.R
\name{read_urban_area}
\alias{read_urban_area}
\title{Download official data of urbanized areas in Brazil as an sf object.}
\usage{
read_urban_area(year = 2015, simplified = TRUE, showProgress = TRUE, tp)
}
\arguments{
\item{year}{A year number in YYYY format (defaults to 2015)}

\item{simplified}{Logic TRUE or FALSE, indicating whether the function returns the 'original' dataset with high resolution or a dataset with 'simplified' borders (Defaults to TRUE)}

\item{showProgress}{Logical. Defaults to (TRUE) display progress bar}

\item{tp}{Argument deprecated. Please use argument 'simplified'}
}
\description{
This function reads the official data on the urban footprint of Brazilian cities
in the years 2005 and 2015. Orignal data were generated by Institute of Geography
and Statistics (IBGE)  For more information about the methodology, see deails at
https://biblioteca.ibge.gov.br/visualizacao/livros/liv100639.pdf
}
\examples{
\dontrun{

library(geobr)

# Read urban footprint of Brazilian cities in an specific year
  d <- read_urban_area(year=2005)

}


}
