% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_estimates.R
\name{get_estimates}
\alias{get_estimates}
\title{Get causal estimates comparing two scenarios}
\usage{
get_estimates(
  obs_dens,
  cf_dens,
  treatment_data,
  smoothed_outcome,
  lag,
  entire_window,
  dist_map,
  dist,
  dist_map_unit = "km",
  grayscale
)
}
\arguments{
\item{obs_dens}{observed density}

\item{cf_dens}{counterfactual density}

\item{treatment_data}{column of a hyperframe that summarizes treatment data. In the form of `hyperframe$column`.}

\item{smoothed_outcome}{column of a hyperframe that summarizes the smoothed outcome data}

\item{lag}{integer that specifies lags to calculate causal estimates}

\item{entire_window}{owin object (the entire region of interest)}

\item{dist_map}{im object (distance map); notice that the unit (either mile or km) is inherited from the distance map}

\item{dist}{a vector of distances for which the function calculates the expectations (e.g., `c(50, 100, 150, 200)`)}

\item{dist_map_unit}{either `"km"` or `"mile"`}

\item{grayscale}{logical. `grayscale` specifies whether to convert plot to grayscale (by default, FALSE).}
}
\value{
list of the following:
`average_expected_events`: Hajek estimators (counts, the entire window)
`average_expected_events_quantiles`: percentiles of Hajek estimators
`weights`: weights
`average_weights`: mean of `weights`
`plot`: plot showing distance-based expectations
`distances`: distances
`distances_window`: as window objects
`expectation_plot`: plot of expectations
`window_plot`: plot of windows
}
\description{
`get_estimates()` generates causal estimates comparing two counterfactual scenarios.
}
