% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_topo.R
\name{geo2topo}
\alias{geo2topo}
\alias{topo2geo}
\title{GeoJSON to TopoJSON and back}
\usage{
geo2topo(x)

topo2geo(x, ...)
}
\arguments{
\item{x}{GeoJSON or TopoJSON as a character string, json, a file path, or url}

\item{...}{for \code{topo2geo} args passed  on to 
\code{\link[rgdal]{readOGR}}}
}
\value{
An object of class \code{json}, of either GeoJSON or TopoJSON
}
\description{
GeoJSON to TopoJSON and back
}
\examples{
# geojson to topojson
x <- '{"type": "LineString", "coordinates": [ [100.0, 0.0], [101.0, 1.0] ]}'
z <- geo2topo(x)
jsonlite::prettify(z)
\dontrun{
library(leaflet)
leaflet() \%>\% 
  addProviderTiles(provider = "Stamen.Terrain") \%>\% 
  addTopoJSON(z)
}

# topojson to geojson
w <- topo2geo(z)
jsonlite::prettify(w)

## larger examples
file <- system.file("examples", "us_states.topojson", package = "geojsonio")
topo2geo(file)
}
\seealso{
\code{\link{topojson_write}}, \code{\link{topojson_read}}
}
