% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOBand.R
\docType{class}
\name{ISOBand}
\alias{ISOBand}
\title{ISOBand}
\format{\code{\link{R6Class}} object.}
\usage{
ISOBand
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOBand
}
\description{
ISOBand
}
\section{Fields}{

\describe{
\item{\code{offset}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOBand
 }
 \item{\code{setMaxValue(maxValue)}}{
   Sets the maximum value
 }
 \item{\code{setMinValue(minValue)}}{
   Sets the minimum value
 }
 \item{\code{setUnits(units)}}{
   Sets the unit, object of class \code{GMLUnitDefinition}
 }
 \item{\code{setPeakResponse(peakResponse)}}{
   Sets the peak response
 }
 \item{\code{setBitsPerValue(bitsPerValue)}}{
   Sets the bits per value
 }
 \item{\code{setToneGradation}}{
   Sets the tone gradation
 }
 \item{\code{setScaleFactor(scaleFactor)}}{
   Sets the scale factor
 }
 \item{\code{setOffset(offset)}}{
   Sets the offset
 }
}
}

\examples{
   #create band range dimension
   md <- ISOBand$new()
   md$setSequenceIdentifier(ISOMemberName$new(aName = "name", attributeType = "type"))
   md$setDescriptor("descriptor")
   md$setMaxValue(10)
   md$setMinValue(1)
   gml <- GMLBaseUnit$new(id = "ID")
   gml$setDescriptionReference("someref")
   gml$setIdentifier("identifier", "codespace")
   gml$addName("name1", "codespace")
   gml$addName("name2", "codespace")
   gml$setQuantityTypeReference("someref")
   gml$setCatalogSymbol("symbol")
   gml$setUnitsSystem("somelink")
   md$setUnits(gml)
   md$setPeakResponse(9)
   md$setBitsPerValue(5)
   md$setToneGradation(100)
   md$setScaleFactor(1)
   md$setOffset(4)
   xml <- md$encode()

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{band}
