% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOExtent.R
\docType{class}
\name{ISOExtent}
\alias{ISOExtent}
\title{ISOExtent}
\format{\code{\link{R6Class}} object.}
\usage{
ISOExtent
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Extent
}
\description{
ISOExtent
}
\section{Fields}{

\describe{
\item{\code{geographicElement}}{[\code{\link{ISOGeographicExtent}}] geographic extent(s)}

\item{\code{temporalElement}}{[\code{\link{ISOTemporalExtent}}] temporal extent(s)}

\item{\code{verticalElement}}{[\code{\link{ISOVerticalExtent}}] vertical extent(s)}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOExtent}}
 }
 \item{\code{addGeographicElement(extent)}}{
   Adds an object extending \code{\link{ISOGeographicExtent}}
 }
 \item{\code{setGeographicElement(extent)}}{
   Sets an object extending \code{\link{ISOGeographicExtent}}
 }
 \item{\code{delGeographicElement(extent)}}{
   Deletes an object extending \code{\link{ISOGeographicExtent}}
 }
 \item{\code{addTemporalElement(extent)}}{
   Adds an object extending \code{\link{ISOTemporalExtent}}
 }
 \item{\code{setTemporalElement(extent)}}{
   Sets an object extending \code{\link{ISOTemporalExtent}}
 }
 \item{\code{delTemporalElement(extent)}}{
   Deletes an object extending \code{\link{ISOTemporalExtent}}
 }
 \item{\code{addVerticalElement(extent)}}{
   Adds an object extending \code{\link{ISOVerticalExtent}}
 }
 \item{\code{setVerticalElement(extent)}}{
   Sets an object extending \code{\link{ISOVerticalExtent}}
 }
 \item{\code{delVerticalElement(extent)}}{
   Deletes an object extending \code{ISOVerticalExtent}
 }
}
}

\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{extent}
