% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOListedValue.R
\docType{class}
\name{ISOListedValue}
\alias{ISOListedValue}
\title{ISOListedValue}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOListedValue
}
\description{
ISOListedValue
}
\section{Fields}{

\describe{
\item{\code{label}}{[\code{\link{character}}] label}

\item{\code{code}}{[\code{\link{character}}] code}

\item{\code{definition}}{[\code{\link{character}}] definition}

\item{\code{definitionReference}}{[\code{\link{ISODefinitionReference}}] definition reference}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOListedValue}}
 }
 \item{\code{setLabel(label, locales)}}{
   Sets the label. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setCode(code, locales)}}{
   Sets the code. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setDefinition(definition, locales)}}{
   Sets the definition. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setDefinitionReference(definitionReference)}}{
   Sets the definition reference, object of class \code{\link{ISODefinitionReference}}
 }
}
}

\examples{
  val <- ISOListedValue$new()
  val$setCode("code1")
  val$setLabel("label1")
  val$setDefinition("definition1")
  xml <- val$encode()
 
}
\references{
ISO 19110:2005 Methodology for Feature cataloguing
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{listed}
\keyword{value}
