% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometa_mapping.R
\name{convert_metadata}
\alias{convert_metadata}
\title{convert_metadata}
\usage{
convert_metadata(obj, from, to, mappings, verbose)
}
\arguments{
\item{obj}{a metadata object given in one of the mapping formats known by \pkg{geometa}.
The object should be a valid \code{id} as listed by \code{\link{getMappingFormats}}, supported
as source format (\code{from} is \code{TRUE}).}

\item{from}{a valid mapping format id (see \code{\link{getMappingFormats}}) that indicates the metadata
model / format used for the argument \code{obj}}

\item{to}{a valid mapping format id (see \code{\link{getMappingFormats}}) to convert to}

\item{mappings}{a \code{data.frame} giving the reference mapping rules to convert metadata object.
This \code{data.frame} is by default the output of \code{\link{getMappings}}.}

\item{verbose}{print debugging messages. Default is \code{FALSE}}
}
\value{
an metadata object in the model specified as \code{to} argument
}
\description{
\code{convert_metadata} is a tentative generic metadata converter to
convert from one source object, represented in a source metadata object model in R
(eg eml) to a target metadata object, represented in another target metadata object
model (eg \pkg{geometa} \code{\link{ISOMetadata}}). This function relies on a list of
mapping rules defined to operate from the source metadata object to the target metadata 
object. This list of mapping rules is provided in a tabular format. A version is embedded 
in \pkg{geometa} and can be returned with \code{\link{getMappings}}.
}
\note{
This function is mainly used internally in \code{as} generic methods to convert from one 
metadata format to another.  It is exported for extension to user custom metadata formats or for
debugging purpose. This converter is still experimental.
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
