% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOConformanceResult.R
\docType{class}
\name{ISOConformanceResult}
\alias{ISOConformanceResult}
\title{ISOConformanceResult}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO ConformanceResult
}
\description{
ISOConformanceResult
}
\section{Fields}{

\describe{
\item{\code{specification}}{[\code{\link{ISOCitation}}] specification citation}

\item{\code{explanation}}{[\code{\link{character}}] explanation about conformance}

\item{\code{pass}}{[\code{\link{logical}}] if the conformance is passing or not}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml,value)}}{
   This method is used to instantiate an \code{\link{ISOConformanceResult}}
 }
 \item{\code{setSpecification(specification)}}{
   Sets the specification (an \code{\link{ISOCitation}} object)
 }
 \item{\code{setExplanation(explanation, locales)}}{
   Sets the explanation. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setPass(pass)}}{
   Sets if passing the conformance or not (logical value)
 }
}
}

\examples{
 md <- ISOConformanceResult$new()
 spec <- ISOCitation$new()
 spec$setTitle("specification title")
 spec$addAlternateTitle("specification alternate title")
 d <- ISODate$new()
 d$setDate(ISOdate(2015, 1, 1, 1))
 d$setDateType("publication")
 spec$addDate(d)
 md$setSpecification(spec)
 md$setExplanation("some explanation about the conformance")
 md$setPass(TRUE)
 xml <- md$encode()
 
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{conformance}
\keyword{result}
