% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTable.R
\docType{methods}
\name{getTable}
\alias{getTable}
\alias{getTable,ANY-method}
\alias{getTable,geom-method}
\alias{getTable,Spatial-method}
\alias{getTable,sf-method}
\alias{getTable,ppp-method}
\alias{getTable,RasterLayer-method}
\alias{getTable,RasterBrick-method}
\alias{getTable,matrix-method}
\title{Get the attribute table of a spatial object.}
\usage{
\S4method{getTable}{ANY}(x)

\S4method{getTable}{geom}(x, slot = NULL)

\S4method{getTable}{Spatial}(x)

\S4method{getTable}{sf}(x)

\S4method{getTable}{ppp}(x)

\S4method{getTable}{RasterLayer}(x)

\S4method{getTable}{RasterBrick}(x)

\S4method{getTable}{matrix}(x)
}
\arguments{
\item{x}{the object from which to derive the attribute table.}

\item{slot}{[\code{character(1)}]\cr the geom slot from which to get the
attribute table, either \code{"point"}, \code{"feature"} or \code{"group"}.
If left at \code{NULL}, 'feature' and 'group' will be joined.}
}
\value{
A table of the attributes of \code{x}.
}
\description{
Get the attribute table of a spatial object.
}
\examples{
getTable(x = gtGeoms$polygon)

getTable(x = gtSP$SpatialPolygons)

getTable(x = gtSF$multiline)

getTable(x = gtPPP)

getTable(x = gtRasters$categorical)
}
\seealso{
Other getters: \code{\link{getCRS}},
  \code{\link{getExtent}}, \code{\link{getHistory}},
  \code{\link{getPoints}}, \code{\link{getSubset}},
  \code{\link{getType}}, \code{\link{getWindow}}
}
\concept{getters}
