% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_locate.R
\name{gt_locate}
\alias{gt_locate}
\title{Locate (and identify) clicks}
\usage{
gt_locate(samples = 1, panel = NULL, identify = FALSE,
  snap = FALSE, raw = FALSE, show = TRUE, ...)
}
\arguments{
\item{samples}{[\code{integerish(1)}]\cr the number of clicks.}

\item{panel}{[\code{character(1)}]\cr the panel in which to locate (i.e. the
title shown over the plot).}

\item{identify}{[\code{logical(1)}]\cr get the raster value or \code{geom} ID
at the sampled location (\code{TRUE}) or merely the location (\code{FALSE},
default).}

\item{snap}{[\code{logical(1)}]\cr should the returned value(s) be set to the
nearest raster cell's center (\code{TRUE}) or should they remain the
selected, "real" value (\code{FALSE}, default)?}

\item{raw}{[\code{logical(1)}]\cr should the complete statistics about the
clicks be returned (\code{TRUE}), or should only the basic output be
returned (\code{FALSE}, default)?}

\item{show}{[\code{logical(1)}]\cr should information be plotted
(\code{TRUE}), or should they merely be returned to the console
(\code{FALSE}, default)?}

\item{...}{[\code{various}]\cr graphical parameters of the objects that are
created when \code{show = TRUE}.}
}
\value{
A \code{tibble} of the selected locations and, if \code{identify
  = TRUE}, the respective values. If \code{show = TRUE} the values are also
  shown in the plot.
}
\description{
Click into a plot to get the location or identify values
}
\examples{
\donttest{
# locate coordinates with geoms
visualise(geom = gtGeoms$polygon)
gt_locate(samples = 2)

# locate or identify values with rasters
visualise(raster = gtRasters$continuous)
gt_locate(identify = TRUE, snap = TRUE)

# with several panels, specify a target
visualise(gtRasters)
gt_locate(samples = 4, panel = "categorical", snap = TRUE, identify = TRUE)
}
}
