% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_translate.R
\name{gt_translate}
\alias{gt_translate}
\title{Translate \code{geom}s}
\usage{
gt_translate(geom = NULL, x = NULL, y = NULL, fid = NULL,
  update = TRUE)
}
\arguments{
\item{geom}{[\code{geom(.)}]\cr the object to translate.}

\item{x}{[\code{numeric(1)}]\cr the translation constant (offset) in
x-dimension.}

\item{y}{[\code{numeric(1)}]\cr the translation constant (offset) in
y-dimension.}

\item{fid}{[\code{integerish(.)}]\cr if only a subset of features shall be
rotated, specify that here.}

\item{update}{[\code{logical(1)}]\cr whether or not to update the window slot
after rotation.}
}
\value{
Mathematically translated \code{geom}.
}
\description{
Translate \code{geom}s by adding a constant in x and y-dimension.
}
\examples{
# the original object
coords <- data.frame(x = c(30, 60, 60, 40, 10, 40, 20),
                     y = c(40, 40, 60, 70, 10, 20, 40),
                     fid = c(1, 1, 1, 1, 2, 2, 2))
window <- data.frame(x = c(0, 80),
                     y = c(0, 80))
aGeom <- gs_polygon(anchor = coords, window = window)

# translate several geoms
visualise(geom = gt_translate(geom = aGeom, x = 5, y = list(-10, 5)))

# translate a single geom
visualise(geom = gt_translate(geom = aGeom, x = 5, fid = 1))
}
\seealso{
Other geometry tools: \code{\link{gt_reflect}},
  \code{\link{gt_rotate}}, \code{\link{gt_scale}},
  \code{\link{gt_sketch}}, \code{\link{gt_skew}},
  \code{\link{gt_stretch}}
}
\concept{geometry tools}
