% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gc_geom.R
\name{gc_geom}
\alias{gc_geom}
\alias{gc_geom,Spatial-method}
\alias{gc_geom,sf-method}
\alias{gc_geom,ppp-method}
\alias{gc_geom,Raster-method}
\title{Transform a spatial object to class \code{geom}}
\usage{
\S4method{gc_geom}{Spatial}(input = NULL, ...)

\S4method{gc_geom}{sf}(input = NULL, group = FALSE, ...)

\S4method{gc_geom}{ppp}(input = NULL, ...)

\S4method{gc_geom}{Raster}(input = NULL, ...)
}
\arguments{
\item{input}{the object to transform to class \code{geom}.}

\item{...}{additional arguments.}

\item{group}{[\code{logical(1)}]\cr should the attributes of multi* features
be grouped, i.e. should the unique values per multi* feature be assigned
into the groups table (\code{TRUE}), or should they be kept as duplicated
per-feature attributes (\code{FALSE}, default)?}
}
\value{
an object of class \code{geom}
}
\description{
Transform a spatial object to class \code{geom}
}
\examples{
gc_geom(input = gtPPP)

gc_geom(input = gtSF$polygon)

gc_geom(input = gtRasters$categorical)
}
\seealso{
Other spatial classes: 
\code{\link{gc_grob}()},
\code{\link{gc_ppp}()},
\code{\link{gc_raster}()},
\code{\link{gc_sf}()},
\code{\link{gc_sp}()}
}
\concept{spatial classes}
