% Generated by roxygen2 (4.0.2): do not edit by hand
\name{define.modules}
\alias{define.modules}
\title{Define modules (landmark partitions)}
\usage{
define.modules(spec, nmodules)
}
\arguments{
\item{spec}{Name of specimen, as an object matrix containing 2D landmark coordinates}

\item{nmodules}{Number of modules to be defined}
}
\value{
Function returns a vector of which landmarks belong in which module (e.g. A,A,A,B,B,B,C,C,C) to be used
with \code{\link{compare.modular.partitions}} option 'landgroups'.
}
\description{
An interactive function to define which landmarks should be assigned to each module (landmark partition).
}
\details{
Function takes a matrix of two-dimensional digitized landmark coordinates and allows the user to assign
landmarks to each module. The output is a list of which
landmarks belong in which partition, to be used by \code{\link{compare.modular.partitions}}.
The number of modules is chosen by the user (up to five).

\subsection{Selection}{
Choosing which landmarks will be included in each module involves landmark selection using a mouse in
the plot window. The user is prompted to select each landmarks for module 1: using the LEFT mouse button
(or regular button for Mac users), click on the hollow circle to choose the landmark. Selected landmarks
will be filled in. When all landmarks for module 1 are chosen, press 'esc', and then start selecting
landmarks for module 2. Repeat until all modules are defined.
}
Note: Function currently only implemented for 2D landmark data.
}
\author{
Emma Sherratt
}
\seealso{
\code{\link{compare.modular.partitions}}
}
\keyword{utilities}

