% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTangentSpace.r
\name{plotTangentSpace}
\alias{plotTangentSpace}
\title{Plot specimens in tangent space}
\usage{
plotTangentSpace(A, axis1 = 1, axis2 = 2, warpgrids = TRUE, mesh = NULL,
  label = NULL, groups = NULL, legend = FALSE)
}
\arguments{
\item{A}{An array (p x k x n) containing landmark coordinates for a set of aligned specimens}

\item{axis1}{A value indicating which PC axis should be displayed as the X-axis (default = PC1)}

\item{axis2}{A value indicating which PC axis should be displayed as the Y-axis (default = PC2)}

\item{warpgrids}{A logical value indicating whether deformation grids for shapes along X-axis should be displayed}

\item{mesh}{A mesh3d object to be warped to represent shape deformation along X-axis (when {warpgrids=TRUE})
as described in \code{\link{plotRefToTarget}}.}

\item{label}{An optional vector indicating labels for each specimen are to be displayed 
(or if TRUE, numerical addresses are given)}

\item{groups}{An optional factor vector specifying group identity for each specimen (see example)}

\item{legend}{A logical value for whether to add a legend to the plot (only when groups are assigned).}
}
\value{
If user assigns function to object, returned is a list of the following components:
\item{pc.summary}{A table summarizing the percent variation explained by each pc axis, equivalent to summary of \code{\link{prcomp}}.}
\item{pc.scores}{The set of principal component scores for all specimens.}
\item{pc.shapes}{A list with the shape coordinates of the extreme ends of all PC axes, e.g. $PC1min}
\item{sdev}{The standard deviations of the principal components (i.e., the square roots of the eigenvalues of the 
covariance/correlation matrix, as per \code{\link{prcomp}}.}
\item{rotation}{The matrix of variable loadings, as per \code{\link{prcomp}}.}
}
\description{
Function plots a set of Procrustes-aligned specimens in tangent space along their principal component axes
}
\details{
The function performs a principal components analysis of shape variation and plots two 
 dimensions of tangent space for a set of Procrustes-aligned specimens (default is PC1 vs. PC2). 
 The percent variation along each PC-axis is returned. Additionally (and optionally, {warpgrids=T}), 
 deformation grids can be requested, which display the shape of specimens at the ends 
 of the range of variability along PC1. If groups are provided, specimens from 
 each group are plotted using distinct colors based on the order in which the groups are found in the dataset, 
 and using R's standard color palette: black, red, green, blue, cyan, magenta, yellow, and gray. NOTE: to change
 the colors of the groups, simply substitute a vector of the desired colors for each specimen (see example below).
 
 NOTE: previous versions of plotTangentSpace had option 'verbose' to return the PC scores and PC shapes. 
 From version 3.0.2 this is automatic when assigned to an object.
}
\examples{
data(plethodon) 
Y.gpa<-gpagen(plethodon$land)    #GPA-alignment

gp <- as.factor(paste(plethodon$species, plethodon$site)) # group must be a factor
plotTangentSpace(Y.gpa$coords, groups = gp) 

## To save and use output
PCA <- plotTangentSpace(Y.gpa$coords, groups = gp, legend=TRUE) 
summary(PCA)
PCA$pc.shapes
PCA$rotation

##To change colors of groups
col.gp <- rainbow(length(levels(gp))) 
   names(col.gp) <- levels(gp)
col.gp <- col.gp[match(gp, names(col.gp))] # col.gp must NOT be a factor
plotTangentSpace(Y.gpa$coords, groups = col.gp)

## To plot residual shapes from an allometry regression (note: must add mean back in!) 
plotTangentSpace(arrayspecs(resid(lm(two.d.array(Y.gpa$coords)~Y.gpa$Csize))+
         predict(lm(two.d.array(Y.gpa$coords)~1)),12,2))
}
\author{
Dean Adams & Emma Sherratt
}
\keyword{visualization}

