% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomultistar_get_empty_geoinstances.R
\name{get_empty_geoinstances}
\alias{get_empty_geoinstances}
\alias{get_empty_geoinstances.geomultistar}
\title{Get empty instances of a geographic attribute}
\usage{
get_empty_geoinstances(gms, dimension = NULL, attribute = NULL)

\method{get_empty_geoinstances}{geomultistar}(gms, dimension = NULL, attribute = NULL)
}
\arguments{
\item{gms}{A \code{geomultistar} object.}

\item{dimension}{A string, dimension name.}

\item{attribute}{A string, attribute name.}
}
\value{
A \code{sf} object.
}
\description{
Gets the instances of the given geographic attribute that do not have a
geometry associated with them.
}
\examples{

gms <- geomultistar(ms = ms_mrs, geodimension = "where") |>
  define_geoattribute(
    attribute = "city",
    from_layer = usa_cities,
    by = c("city" = "city", "state" = "state")
  )

  empty <- gms |>
     get_empty_geoinstances(attribute = "city")

}
\seealso{
Other geo functions: 
\code{\link{define_geoattribute}()},
\code{\link{geomultistar}()},
\code{\link{run_geoquery}()}
}
\concept{geo functions}
