% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{fit_poisson_model}
\alias{fit_poisson_model}
\title{Fit a Penalized Spline Poisson Model on a Geometric Network}
\usage{
fit_poisson_model(
  data,
  Z,
  K,
  ind,
  rho = 10,
  rho_max = 1e+05,
  eps_rho = 0.01,
  maxit_rho = 100
)
}
\arguments{
\item{data}{The binned data.}

\item{Z}{The (sparse) model matrix where the number of columns must
correspond to the length of the vector of model coefficients \code{theta}.}

\item{K}{A (sparse) square penalty matrix of with the same dimension as
\code{theta}.}

\item{ind}{A list which contains the indices belonging to each smooth term
and the linear terms.}

\item{rho}{An initial estimate of the smoothing parameter. Either a vector
of length one or a vector which corresponds to the count of smooth terms
(including the baseline intensity) in the model.}

\item{rho_max}{If \code{rho} exceeds \code{rho_max}, the algorithm stops
and returns the current values.}

\item{eps_rho}{The termination condition for \code{rho}.}

\item{maxit_rho}{Maximum number of iterations for \code{rho}.}
}
\value{
Model fit.
}
\description{
\code{fit_poisson_model} is called from \code{\link[geonet]{intensity_pspline}}
and performs the iterative algorithm to estimate the model parameters and the
smoothing parameters \eqn{rho} in the penalized Poisson model.
}
\details{
Smoothing parameters are estimated using the generalized Fellner-Schall
method (Wood and Fasiolo, 2017).
}
\references{
Wood, S. N. and Fasiolo, M. (2017). A generalized Fellner-Schall
method for smoothing parameter optimization with application to
Tweedie location, scale and shape models. Biometrics 73 1071-1081.
}
\author{
Marc Schneble \email{marc.schneble@stat.uni-muenchen.de}
}
