% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-analysis.R
\name{prep_car_data2}
\alias{prep_car_data2}
\title{Prepare data for the CAR model: raster analysis}
\source{
Griffith, Daniel A. (2000). Eigenfunction properties and approximations of selected incidence matrices employed in spatial analyses. \emph{Linear Algebra and its Applications} 321 (1-3): 95-112. \doi{10.1016/S0024-3795(00)00031-8}.
}
\usage{
prep_car_data2(row = 100, col = 100)
}
\arguments{
\item{row}{Number of rows in the raster}

\item{col}{Number of columns in the raster}
}
\description{
Prepare a list of data required for the CAR model; this is for working with (large) raster data files only. For non-raster analysis, see \link[geostan]{prep_car_data}.
}
\details{
Prepare input data for the CAR model when your dataset consists of observations on a regular (rectangular) tessellation, such as a raster layer or remotely sensed imagery. The rook criteria is used to determine adjacency. This function uses Equation 5 from Griffith (2000) to generate approximate eigenvalues for a row-standardized spatial weights matrix from a P-by-Q dimension regular tessellation.

This function can accomodate very large numbers of observations for use with \code{\link[geostan]{stan_car}}; for large N data, it is also recommended to use \code{slim = TRUE} or the \code{drop} argument. For more details, see: \code{vignette("raster-regression", package = "geostan")}.
}
\examples{

row = 100
col = 120
car_dl <- prep_car_data2(row = row, col = col)

}
\seealso{
\code{\link[geostan]{prep_sar_data2}}, \code{\link[geostan]{prep_car_data}}, \code{\link[geostan]{stan_car}}.
}
