% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilZ.R
\name{calcDCrit}
\alias{calcDCrit}
\title{calcDCrit}
\usage{
calcDCrit(Z, map, optiCrit = 2, pErr = 0.9, simplitol = 0.001)
}
\arguments{
\item{Z}{zoning geometry (list pf SpatialPolygons)}

\item{map}{object returned by function genMap}

\item{optiCrit}{criterion choice}

\item{pErr}{equality tolerance for distance calculations, default 0.9}

\item{simplitol}{tolerance for spatial polygons geometry simplification, default 0.001}
}
\value{
a list with components
\describe{
\item{resD}{list with uncorrected and corrected distance matrix}
\item{resCrit}{list with criterion and cost values}
}
}
\description{
calcDCrit
}
\details{
computes distances and criterion value for zoning Z
}
\examples{
data(mapTest)
data(resZTest)
Z=resZTest$zonePolygone
Z1=zoneFusion4(Z,6,2)
calcDCrit(Z1,mapTest)
}
