% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GermSynchrony.R
\name{GermSynchrony}
\alias{GermSynchrony}
\alias{GermUncertainty}
\title{Synchrony and uncertainty of germination}
\usage{
GermSynchrony(germ.counts, intervals, partial = TRUE)

GermUncertainty(germ.counts, intervals, partial = TRUE)
}
\arguments{
\item{germ.counts}{Germination counts at each time interval. Can be partial or
cumulative as specified in the argument \code{partial}.}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}
}
\value{
For \code{GermUncertainty}, the value of uncertainty of germination
 process.

 For \code{GermSynchrony}, the value of synchrony of germination.
}
\description{
Compute the following metrics:\describe{ \item{\code{GermSynchrony}}{
Synchrony of germination (\ifelse{html}{\out{<i>Z</i>}}{\eqn{Z}} index). }
\item{\code{GermUncertainty}}{ Synchronization index
(\ifelse{html}{\out{<em><span style="text-decoration:
overline">E</span></em>}}{\eqn{\overline{E}}}) or Uncertainty of the
germination process (\ifelse{html}{\out{<i>U</i>}}{\eqn{U}}) or Informational
entropy (\ifelse{html}{\out{<i>H</i>}}{\eqn{H}}).} }
}
\details{
\code{GermSynchrony} computes the value of synchrony of germination (\ifelse{html}{\out{<i>Z</i>}}{\eqn{Z}}
index) as follows (Primack, 1980; Ranal and Santana, 2006).

\ifelse{html}{\out{<p style="text-align: center;"><em>Z =
<sup>&sum;<sup>k</sup><sub style="line-height: 1.8; margin-left:
-1ex;">i=1</sub>C<sub>N<sub>i</sub>,2</sub></sup>
&frasl;<sub>C<sub>&sum;N<sub>i</sub>,2</sub></sub></em></p>}}{\deqn{Z=\frac{\sum_{i=1}^{k}C_{N_{i},2}}{C_{\Sigma
N_{i},2}}}}

Where,
\ifelse{html}{\out{<i>C<sub>N<sub>i</sub>,2</sub></i>}}{\eqn{C_{N_{i},2}}} is
the partial combination of the two germinated seeds from among
\ifelse{html}{\out{N<sub>i</sub>}}{\eqn{N_{i}}}, the number of seeds
germinated on the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th time (estimated as
\ifelse{html}{\out{<em>C<sub>N<sub>i</sub>,2</sub> =
<sup>[N<sub>i</sub>(N<sub>i</sub>-1)]</sup> &frasl;
<sub>2</sub></em>}}{\eqn{C_{N_{i},2}=\frac{N{i}(N{i}-1)}{2}}}) and
\ifelse{html}{\out{<em>C<sub>&sum;N<sub>i</sub>,2</sub></em>}}{\eqn{C_{\Sigma
N_{i},2}}} is the partial combination of the two germinated seeds from among
the total number of seeds germinated at the final count, assuming that all
seeds that germinated did so simultaneously.

\code{GermUncertainty} computes the value of synchronization index
(\ifelse{html}{\out{<em><span style="text-decoration:
overline">E</span></em>}}{\eqn{\overline{E}}}) or uncertainty of the
germination process (\ifelse{html}{\out{<i>U</i>}}{\eqn{U}}) or informational entropy (\ifelse{html}{\out{<i>H</i>}}{\eqn{H}}) as follows
(Shannon, 1948; Labouriau and Valadares, 1976; Labouriau 1983).

\ifelse{html}{\out{<p style="text-align: center;"><em><span
style="text-decoration: overline;">E</span> = &minus;&sum;<sup>k</sup><sub
style="line-height: 1.8; margin-left: -1ex;">i=1</sub> f<sub>i</sub></em>log
<sub>2</sub><em>f<sub>i</sub></em></p>}}{\deqn{\overline{E} =
-\sum_{i=1}^{k}f_{i}\log_{2}f_{i}}}

Where, \ifelse{html}{\out{<i>f<sub>i</sub></i>}}{\eqn{f_{i}}} is the relative
frequency of germination (estimated as \ifelse{html}{\out{<em>f<sub>i</sub> =
<sup>N<sub>i</sub></sup> &frasl; <sub>&sum;<sup>k</sup><sub
style="line-height: 1.8; margin-left:
-1ex;">i=1</sub>N<sub>i</sub></sub></em>}}{\eqn{f_{i}=\frac{N_{i}}{\sum_{i=1}^{k}N_{i}}}}),
\ifelse{html}{\out{<i>N<sub>i</sub></i>}}{\eqn{N_{i}}} is the number of seeds
germinated on the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th time and \ifelse{html}{\out{<i>k</i>}}{\eqn{k}} is the last day of observation.
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)

# From partial germination counts
#----------------------------------------------------------------------------
GermSynchrony(germ.counts = x, intervals = int)
GermUncertainty(germ.counts = x, intervals = int)

# From cumulative germination counts
#----------------------------------------------------------------------------
GermSynchrony(germ.counts = y, intervals = int, partial = FALSE)
GermUncertainty(germ.counts = y, intervals = int, partial = FALSE)

}
\references{
\insertRef{shannon_mathematical_1948}{germinationmetrics}

\insertRef{labouriau_germination_1976}{germinationmetrics}

\insertRef{labouriau_uma_1983}{germinationmetrics}

\insertRef{primack_longevity_1985}{germinationmetrics}

\insertRef{ranal_how_2006}{germinationmetrics}
}
\seealso{
\code{\link[germinationmetrics]{CUGerm}}
}
