% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.FourPHFfit.R
\name{plot.FourPHFfit}
\alias{plot.FourPHFfit}
\title{Plot the four-parameter hill function fitted cumulative germination curve
from a \code{FourPHFfit} object}
\usage{
\method{plot}{FourPHFfit}(
  x,
  rog = TRUE,
  t50.total = TRUE,
  t50.germ = TRUE,
  tmgr = TRUE,
  mgt = TRUE,
  uniformity = TRUE,
  limits = TRUE,
  plotlabels = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{FourPHFfit} obtained as output from the
\code{\link[germinationmetrics]{FourPHFfit}} function.}

\item{rog}{If \code{TRUE}, plots the Rate of Germination curve (RoG). Default
is \code{TRUE}.}

\item{t50.total}{If \code{TRUE}, highlights the time required for 50\% of
total seeds to germinate (\mjseqn{\textrm{t}_{\textrm{50}_\textrm{Total}}})
as a vertical line. Default is \code{TRUE}.}

\item{t50.germ}{If \code{TRUE}, highlights the time required for 50\% of
viable/germinated seeds to germinate
(\mjseqn{\textrm{t}_{\textrm{50}_\textrm{Germ}}}) as a vertical line.
Default is \code{TRUE}.}

\item{tmgr}{If \code{TRUE}, highlights the Time at Maximum Germination Rate
(TMGR) as a vertical line. Default is \code{TRUE}.}

\item{mgt}{If \code{TRUE}, highlights the Mean Germination Time (MGT) as a
vertical line. Default is \code{TRUE}.}

\item{uniformity}{If \code{TRUE}, highlights the uniformity value
(\mjseqn{\textrm{U}_{\textrm{t}_{\textrm{max}}-\textrm{t}_{\textrm{min}}}})
as a horizontal line. Default is \code{TRUE}.}

\item{limits}{logical. If \code{TRUE}, set the limits of y axis (germination
percentage) between 0 and 100 in the germination curve plot. If
\code{FALSE}, limits are set according to the data. Default is \code{TRUE}.}

\item{plotlabels}{logical. If \code{TRUE}, adds labels to the germination
curve plot. Default is \code{TRUE}.}

\item{\dots}{Default plot arguments.}
}
\value{
The plot of the cumulative germination curve as an object of class
  \code{ggplot}.
}
\description{
\code{plot.FourPHFfit} plots the four-parameter hill function fitted
cumulative germination curve (FPHF curve) from a \code{FourPHFfit} object as
an object of class \code{ggplot}. Further, the rate of germination curve (RoG
curve) is plotted and different parameters annotated as specified in the
different arguments. \loadmathjax
}
\examples{

\donttest{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)
total.seeds = 50

# From partial germination counts
#----------------------------------------------------------------------------
fit1 <- FourPHFfit(germ.counts = x, intervals = int,
                   total.seeds = 50, tmax = 20)

# From cumulative germination counts
#----------------------------------------------------------------------------
fit2 <- FourPHFfit(germ.counts = y, intervals = int,
                   total.seeds = 50, tmax = 20, partial = FALSE)

# Default plots
plot(fit1)
plot(fit2)

# No labels
plot(fit1, plotlabels = FALSE)
plot(fit2, plotlabels = FALSE)

# Only the FPHF curve
plot(fit1, rog = FALSE, t50.total = FALSE, t50.germ = FALSE,
     tmgr = FALSE, mgt = FALSE, uniformity = FALSE)
plot(fit2, rog = FALSE, t50.total = FALSE, t50.germ = FALSE,
     tmgr = FALSE, mgt = FALSE, uniformity = FALSE)

# Without y axis limits adjustment
plot(fit1, limits = FALSE)
plot(fit2, limits = FALSE)
}

}
\seealso{
\code{\link[germinationmetrics]{FourPHFfit}}
}
