% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_tb_burden.R
\name{summarise_tb_burden}
\alias{summarise_tb_burden}
\title{Summarise TB Burden}
\usage{
summarise_tb_burden(df = NULL, dict = NULL, metric = "e_inc_100k",
  metric_label = NULL, conf = c("_lo", "_hi"), years = NULL,
  samples = 1000, countries = NULL, compare_to_region = FALSE,
  compare_to_world = FALSE, custom_compare = NULL,
  compare_all_regions = FALSE, stat = "mean", denominator = NULL,
  truncate_at_zero = TRUE, annual_change = FALSE,
  download_data = TRUE, save = TRUE, burden_save_name = "TB_burden",
  dict_save_name = "TB_data_dict", verbose = TRUE)
}
\arguments{
\item{df}{Dataframe of TB burden data, as sourced by \code{\link[getTBinR]{get_tb_burden}}.
If not specified then will source the WHO TB burden data, either locally if available
or directly from the WHO (if \code{download_data = TRUE}).}

\item{dict}{A tibble of the data dictionary. See \code{\link[getTBinR]{get_data_dict}}
for details. If not supplied the function will attempt to load a saved version of the
dictionary. If this fails and \code{download_data = TRUE} then the dictionary will be downloaded.}

\item{metric}{Character string specifying the metric to plot}

\item{metric_label}{Character string specifying the metric label to use.}

\item{conf}{Character vector specifying the name variations to use to specify the upper
and lower confidence intervals. Defaults to \code{NULL} for which no confidence intervals
are used. Used by \code{annual_change}.}

\item{years}{Numeric vector of years. Defaults to \code{NULL} which includes all years in the data.}

\item{samples}{Numeric, the number of samples to use to generate confidence
intervals (only used when \code{conf} are present)}

\item{countries}{A character string specifying the countries to plot.}

\item{compare_to_region}{Logical, defaults to \code{FALSE}. If \code{TRUE} all
countries that share a region with those listed in \code{countries} will be plotted.
Note that this will override settings for \code{facet}, unless it is set to "country".}

\item{compare_to_world}{Logical, defaults to \code{FALSE}. Should a comparision be made to
the metric of interests global value.}

\item{custom_compare}{Logical, defaults to \code{NULL}. A named list of custom countries.}

\item{compare_all_regions}{Logical, defaults to \code{FALSE}. Should all regions be compared.}

\item{stat}{Character string, defaults to \code{"mean"}. The statistic to use to summarise the metric, currently
"mean" and "median" are supported. Note "mean" and "median" do not recompute the supplied country levels values.
Future options will include the weighted proportion and the summarised incidence rate.}

\item{denominator}{Character string identifying the variable to use as a denominator in any proportion or rate calculation.}

\item{truncate_at_zero}{Logical, defaults to \code{TRUE}. Should lower bounds be truncated at zero?}

\item{annual_change}{Logical, defaults to \code{FALSE}. If \code{TRUE} then the
percentage annual change is computed for the specified metric.}

\item{download_data}{Logical, defaults to \code{TRUE}. If not found locally should the data be
downloaded from the specified URL?}

\item{save}{Logical, should the data be saved for reuse during the current R session. Defaults to
\code{TRUE}. If \code{TRUE} then the data is saved to the temporary directory specified by \code{\link[base]{tempdir}}.}

\item{burden_save_name}{Character string, name to save the data under. Defaults to
"TB_burden".}

\item{dict_save_name}{Character string, name to save dictionary under. Defaults to
\code{TB_data_dict}.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should additional status and progress messages
be displayed.}
}
\value{
A tibble containing summarised values (with 95% confidence intervals) for the metric of choice
stratified by area and year.
}
\description{
Summarise TB burden metrics by region, globally, and for custom groupings. For variables with
uncertainty represented by confidence intervals bootstrapping can be used (assuming a normal distribution) to
include this in any estimated summary measures. Currently two statistics are supported; the mean (with
95\% confidence intervals) and the median (with 95\% interquartile range). An incidence rate and weighted proportion
statistic are in development.
}
\examples{

## Get the most recent year of data
tb_burden <- get_tb_burden()
most_recent_year <- max(tb_burden$year)

## Get summary of the e_mdr_pct_rr_new cases
summarise_tb_burden(metric = "e_mdr_pct_rr_new",
                    years =  most_recent_year,
                    samples = 100,
                    compare_all_regions = TRUE,
                    compare_to_world = TRUE,
                    verbose = TRUE)
\dontrun{
## Get median (with 95\% IQR) of the case fatality rate for regions and the world
## Boostrapping uncertainty in country measures
summarise_tb_burden(metric = "cfr",
                    years =  most_recent_year,
                    samples = 100,
                    stat = "median",
                    compare_all_regions = TRUE,
                    compare_to_world = TRUE,
                    verbose = FALSE)


## Get summary data for the UK, Europe and the world
## Bootstrapping CI's 
summarise_tb_burden(metric = "e_inc_num",
                    samples = 100,
                    stat = "median",
                    countries = "United Kingdom", 
                    compare_to_world = TRUE, 
                    compare_to_region = TRUE,
                    verbose = FALSE)
}                     
}
