% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_indicators.R
\name{get_indicators}
\alias{get_indicators}
\title{Extract the retained indicators from an \code{isatpanel} object}
\usage{
get_indicators(object, uis_breaks = NULL)
}
\arguments{
\item{object}{An object produced by the isatpanel function.}

\item{uis_breaks}{A string with the names of user-specified indicators.}
}
\value{
A list of indicators.
}
\description{
Extract the retained indicators from an \code{isatpanel} object
}
\examples{
\donttest{
data(EU_emissions_road)

# Group specification
EU15 <- c("Austria", "Germany", "Denmark", "Spain", "Finland", "Belgium",
         "France", "United Kingdom", "Ireland", "Italy", "Luxembourg",
         "Netherlands", "Greece", "Portugal", "Sweden")

# Prepare sample and data
EU_emissions_road_short <- EU_emissions_road[
EU_emissions_road$country \%in\% EU15 &
EU_emissions_road$year >= 2000,
]

# Run
result <- isatpanel(
  data = EU_emissions_road_short,
  formula = ltransport.emissions ~ lgdp + I(lgdp^2) + lpop,
  index = c("country", "year"),
  effect = "twoways",
  fesis = TRUE,
  plot = FALSE,
  t.pval = 0.01
)
plot(result)
plot_grid(result)

# print the retained indicators
get_indicators(result)
}
}
