% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocRank.R
\name{LocRank}
\alias{LocRank}
\title{Localized ranking familty}
\usage{
LocRank(K)
}
\arguments{
\item{K}{Indicates that we are interesting in the top \eqn{K} instances and their correct ordering. Must be an integer
between 1 and the number \eqn{n} of observations.}
}
\value{
A Boosting family object
}
\description{
{Gradient-free Gradient Boosting family for the localized ranking loss function including its fast
computation.}
}
\details{
{The localized ranking loss combines the hard and the weak ranking loss, i.e., it penalizes misrankings at
the top of the list (the best \eqn{K} instances according to the response value) and ''misclassification'' in the sense
that instances belonging to the top of the list are ranked lower and vice versa. The localized ranking loss already
returns a normalized loss that can take values between 0 and 1. \code{LocRank} returns a family object
as in the package \code{mboost}.}
}
\examples{
{y<-c(-3, 10.3,-8, 12, 14,-0.5, 29,-1.1,-5.7, 119)
 yhat<-c(0.02, 0.6, 0.1, 0.47, 0.82, 0.04, 0.77, 0.09, 0.01, 0.79)
 LocRank(4)@risk(y,yhat)}
{y<-c(-3, 10.3,-8, 12, 14,-0.5, 29,-1.1,-5.7, 119)
 yhat<-c(0.02, 0.6, 0.1, 0.47, 0.82, 0.04, 0.77, 0.09, 0.01, 0.79)
 LocRank(5)@risk(y,yhat)}
}
\references{
{Werner, T., Gradient-Free Gradient Boosting, PhD Thesis, Carl von Ossietzky University Oldenburg, 2020,
Equation (5.2.5)}

{T. Hothorn, P. Bühlmann, T. Kneib, M. Schmid, and B. Hofner. mboost: Model-Based
Boosting, 2017}
}
