% Generated by roxygen2 (4.0.2): do not edit by hand
\name{animate_annual}
\alias{animate_annual}
\title{Plot an animation of forest change within a given area of interest (AOI)}
\usage{
animate_annual(aoi, gfc_stack, out_dir = getwd(),
  out_basename = "gfc_animation", site_name = "", type = "html",
  height = 3, width = 3, dpi = 300)
}
\arguments{
\item{aoi}{one or more AOI polygons as a \code{SpatialPolygonsDataFrame}
object.  If there is a 'label' field  in the dataframe, it will be used to
label the polygons in the plots. If the AOI is not in the WGS84 geographic
coordinate system, it will be reprojected to WGS84.}

\item{gfc_stack}{a GFC product subset as a
\code{RasterStack} (as output by \code{\link{annual_stack}})}

\item{out_dir}{folder for animation output}

\item{out_basename}{basename to use when naming animation files}

\item{site_name}{name of the site (used in making title)}

\item{type}{type of animation to make. Can be either "gif" or "html"}

\item{height}{desired height of the animation GIF in inches}

\item{width}{desired width of the animation GIF in inches}

\item{dpi}{dots per inch for the output image}
}
\description{
Produces an animation of annual forest change in the area bounded by the
extent of a given AOI, or AOIs. The AOI polygon(s) is(are) also plotted on
the image.  The \code{gfc_stack} must be pre-calculated using the
\code{\link{annual_stack}} function. The animation can be either an animated
GIF (if \code{type} is set to 'gif') or a series of '.png' files with a
corresponding '.html' webpage showing a simple viewer and the forest change
animation (if \code{type} is set to 'html'). The HTML option is recommended
as it requires no additional software to produce it. The animated GIF option
will only work if the imagemagicK software package is installed beforehand
(this is done outside of R).
}
\seealso{
\code{\link{annual_stack}}
}

