% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histories.R
\name{lagged}
\alias{lagged}
\alias{cumavg}
\alias{lagavg}
\title{History functions}
\usage{
lagged(pool, histvars, histvals, time_name, t, id_name, baselags,
  below_zero_indicator)

cumavg(pool, histvars, time_name, t, id_name, below_zero_indicator)

lagavg(pool, histvars, histvals, time_name, t, id_name, baselags,
  below_zero_indicator)
}
\arguments{
\item{pool}{Data table containing all information prior to time \eqn{t} (\eqn{t} noninclusive).}

\item{histvars}{Vector of character strings specifying the names of the variables for which history functions are to be applied.}

\item{histvals}{For \code{lagged}, this argument is a vector specifying the lags used in the model statements (e.g., if \code{lag1_varname} and \code{lag2_varname} were included in the model statements, this vector would be \code{c(1,2)}). For \code{lagavg}, this argument is a numeric vector specifying the lag averages used in the model statements.}

\item{time_name}{Character string specifying the name of the time variable in \code{pool}.}

\item{t}{Integer specifying the current time index.}

\item{id_name}{Character string specifying the name of the ID variable in \code{pool}.}

\item{baselags}{Logical scalar for specifying the convention used for lagi and lag_cumavgi terms in the model statements when pre-baseline times are not
included in \code{obs_data} and when the current time index, \eqn{t}, is such that \eqn{t < i}. If this argument is set to \code{FALSE}, the value
of all lagi and lag_cumavgi terms in this context are set to 0 (for non-categorical covariates) or the reference
level (for categorical covariates). If this argument is set to \code{TRUE}, the value of lagi and lag_cumavgi terms
are set to their values at time 0. The default is \code{FALSE}.}

\item{below_zero_indicator}{Logical scalar indicating whether the observed data set contains rows for time \eqn{t < 0}.}
}
\value{
No value is returned. The data table \code{pool} is modified in place.
}
\description{
These functions create new columns in an input data table for covariate histories. Users must specify which covariates are to be used in the history functions.
}
\details{
\code{lagged} creates new columns for lagged versions of existing
variables in the dataset. The user must specify which variables are to be lagged.

\code{cumavg} creates new columns for the cumulative average up until
time \eqn{t} of existing variables in the dataset.

\code{lagavg} creates new columns for the "lagged cumulative average"
(cumulative average up until time t, then lagged by one time unit) up until time \eqn{t} of existing
variables in the dataset.
}
\examples{
## Estimating the effect of static treatment strategies on risk of a
## failure event
\donttest{
id <- 'id'
time_points <- 7
time_name <- 't0'
covnames <- c('L1', 'L2', 'A')
outcome_name <- 'Y'
covtypes <- c('binary', 'bounded normal', 'binary')
histories <- c(lagged, lagavg)
histvars <- list(c('A', 'L1', 'L2'), c('L1', 'L2'))
covparams <- list(covmodels = c(L1 ~ lag1_A + lag_cumavg1_L1 + lag_cumavg1_L2 +
                                  L3 + t0,
                                L2 ~ lag1_A + L1 + lag_cumavg1_L1 +
                                  lag_cumavg1_L2 + L3 + t0,
                                A ~ lag1_A + L1 + L2 + lag_cumavg1_L1 +
                                  lag_cumavg1_L2 + L3 + t0))
ymodel <- Y ~ A + L1 + L2 + L3 + lag1_A + lag1_L1 + lag1_L2 + t0
intvars <- list('A', 'A')
interventions <- list(list(c(static, rep(0, time_points))),
                      list(c(static, rep(1, time_points))))
int_descript <- c('Never treat', 'Always treat')
nsimul <- 10000

gform_basic <- gformula_survival(obs_data = basicdata_nocomp, id = id,
                                 time_points = time_points,
                                 time_name = time_name, covnames = covnames,
                                 outcome_name = outcome_name,
                                 covtypes = covtypes,
                                 covparams = covparams, ymodel = ymodel,
                                 intvars = intvars,
                                 interventions = interventions,
                                 int_descript = int_descript,
                                 histories = histories, histvars = histvars,
                                 basecovs = c('L3'), nsimul = nsimul,
                                 seed = 1234)
gform_basic
}

}
