% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{Edge}
\alias{Edge}
\title{Edge generation}
\usage{
Edge(state1, state2, type = "null", decay = 1, gap = 0,
  penalty = 0, K = Inf, a = 0)
}
\arguments{
\item{state1}{a string defining the starting state of the edge}

\item{state2}{a string defining the ending state of the edge}

\item{type}{a string equal to "null", "std", "up", "down" or "abs"}

\item{decay}{a nonnegative number to give the strength of the exponential decay into the segment}

\item{gap}{a nonnegative number to constrain the size of the gap in the change of state}

\item{penalty}{a nonnegative number. The penality associated to this state transition}

\item{K}{a positive number. Threshold for the Biweight robust loss}

\item{a}{a positive number. Slope for the Huber robust loss}
}
\value{
a one-row dataframe with 9 variables
}
\description{
Edge creation for graph
}
\examples{
Edge("Dw", "Up", "up", gap = 1, penalty = 10, K = 3)
}
