% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeDrawings.R
\name{timeDrawings}
\alias{timeDrawings}
\title{Time drawings of random graphs}
\usage{
timeDrawings(niter = 100, sizes = seq(250, 25, -25), eprob = 0.2,
  wd = "./", newpack = NULL, classnew = NULL, newcode = NULL)
}
\arguments{
\item{niter}{integer. How many times to repeat each drawing for each drawing method. Default is 100.}

\item{sizes}{integer vector. What size(s) of network (how many nodes) should be drawn? Default is \code{seq(250,25,-25)}.}

\item{eprob}{numeric. Value between 0-1. Edge probability of random graph. Default is .2.}

\item{wd}{character. Working directory where you want to store the timing results. Default is current working directory.}

\item{newpack}{character. Name of additional package (or function) that you wish to compare to \pkg{igraph}, \pkg{network}, \code{\link[GGally]{ggnet2}}, \pkg{geomnet}, and \pkg{ggnetwork}.}

\item{classnew}{character. Class of object taken to be plotted with the new method. (think \code{"igraph"}, \code{"network"}, etc.)}

\item{newcode}{expression. The code required to plot the random graph using the \code{newpack} method. Must take an object called \code{n} for plotting.}
}
\description{
Time drawings of random graphs
}

