% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_methylation_from_fastq.R
\name{write_fastq}
\alias{write_fastq}
\title{Write sequence and quality information to FASTQ}
\usage{
write_fastq(
  dataframe,
  filename = NA,
  read_id_colname = "read",
  sequence_colname = "sequence",
  quality_colname = "quality",
  return = FALSE
)
}
\arguments{
\item{dataframe}{\code{dataframe}. Dataframe containing modification information to write back to modified FASTQ. Must have columns for unique read ID and DNA sequence. Should also have a column for quality, unless wanting to fill in qualities with \code{"B"}.}

\item{filename}{\code{character}. File to write the FASTQ to. Recommended to end with \code{.fastq} (warns but works if not). If set to \code{NA} (default), no file will be output, which may be useful for testing/debugging.}

\item{read_id_colname}{\code{character}. The name of the column within the dataframe that contains the unique ID for each read. Defaults to \code{"read"}.}

\item{sequence_colname}{\code{character}. The name of the column within the dataframe that contains the DNA sequence for each read. Defaults to \code{"sequence"}.\cr\cr The values within this column must be DNA sequences e.g. \code{"GGCGGC"}.}

\item{quality_colname}{\code{character}. The name of the column within the dataframe that contains the FASTQ quality scores for each read. Defaults to \code{"quality"}. If scores are not known, can be set to \code{NA} to fill in quality with \code{"B"}.\cr\cr If not \code{NA}, must correspond to a column where the values are the FASTQ quality scores e.g. \verb{"$12\\">/2C;4:9F8:816E,6C3*,"} - see \code{\link{fastq_quality_scores}}.}

\item{return}{\code{logical}. Boolean specifying whether this function should return the FASTQ (as a character vector of each line in the FASTQ), otherwise it will return \code{invisible(NULL)}. Defaults to \code{FALSE}.}
}
\value{
\verb{character vector}. The resulting FASTQ file as a character vector of its constituent lines (or \code{invisible(NULL)} if \code{return} is \code{FALSE}). This is probably mostly useful for debugging, as setting \code{filename} within this function directly writes to FASTQ via \code{\link[=writeLines]{writeLines()}}. Therefore, defaults to returning \code{invisible(NULL)}.
}
\description{
This function simply writes a FASTQ file from a dataframe containing
columns for read ID, sequence, and quality scores.\cr\cr
See \code{\link{fastq_quality_scores}} for an explanation of quality.\cr\cr
Said dataframe can be produced from FASTQ via \code{\link[=read_fastq]{read_fastq()}}.
To read/write a modified FASTQ containing modification information
(SAM/BAM MM and ML tags) in the header lines, use
\code{\link[=read_modified_fastq]{read_modified_fastq()}} and \code{\link[=write_modified_fastq]{write_modified_fastq()}}.
}
\examples{
## Write to FASTQ (using filename = NA, return = FALSE
## to view as char vector rather than writing to file)
write_fastq(
    example_many_sequences,
    filename = NA,
    read_id_colname = "read",
    sequence_colname = "sequence",
    quality_colname = "quality",
    return = TRUE
)

## quality_colname = NA fills in quality with "B"
write_fastq(
    example_many_sequences,
    filename = NA,
    read_id_colname = "read",
    sequence_colname = "sequence",
    quality_colname = NA,
    return = TRUE
)

}
